/**
 * amis-formula v6.3.0
 * Copyright 2021-2024 fex
 */

'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var evalutor = require('./evalutor.js');

var functions = {};
function registerFunction(name, fn) {
    functions["fn".concat(name)] = fn;
    evalutor.Evaluator.setDefaultFunctions(functions);
}
var functionDocs = {};
function registerFunctionDoc(groupName, item) {
    if (functionDocs[groupName]) {
        functionDocs[groupName].push(item);
    }
    else {
        functionDocs[groupName] = [item];
    }
}

exports.functionDocs = functionDocs;
exports.functions = functions;
exports.registerFunction = registerFunction;
exports.registerFunctionDoc = registerFunctionDoc;
