"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.axiosErrorCatcher = exports.AmplitudeErrorResponse = void 0;
class AmplitudeErrorResponse extends Error {
    constructor(err) {
        super(err.message);
        this.status = err.response.status;
        this.data = err.response.data;
    }
}
exports.AmplitudeErrorResponse = AmplitudeErrorResponse;
exports.axiosErrorCatcher = (reqPromise) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const res = yield reqPromise;
        return res;
    }
    catch (err) {
        if (err.response) {
            throw new AmplitudeErrorResponse(err);
        }
        throw err;
    }
});
//# sourceMappingURL=errors.js.map