import { getGlobalScope } from '@amplitude/analytics-client-common';
import * as amplitude from './index';
import { runQueuedFunctions } from './utils/snippet-helper';
// https://developer.mozilla.org/en-US/docs/Glossary/IIFE
(function () {
    var GlobalScope = getGlobalScope();
    if (!GlobalScope) {
        console.error('[Amplitude] Error: GlobalScope is not defined');
        return;
    }
    GlobalScope.amplitude = Object.assign(GlobalScope.amplitude || {}, amplitude);
    if (GlobalScope.amplitude.invoked) {
        var queue = GlobalScope.amplitude._q;
        GlobalScope.amplitude._q = [];
        runQueuedFunctions(amplitude, queue);
        for (var i = 0; i < GlobalScope.amplitude._iq.length; i++) {
            var instance = Object.assign(GlobalScope.amplitude._iq[i], amplitude.createInstance());
            var queue_1 = instance._q;
            instance._q = [];
            runQueuedFunctions(instance, queue_1);
        }
    }
})();
//# sourceMappingURL=snippet-index.js.map