var _this = this;
Object.defineProperty(exports, "__esModule", { value: true });
exports.networkConnectivityCheckerPlugin = void 0;
var tslib_1 = require("tslib");
var analytics_client_common_1 = require("@amplitude/analytics-client-common");
var networkConnectivityCheckerPlugin = function () {
    var name = '@amplitude/plugin-network-checker-browser';
    var type = 'before';
    var globalScope = (0, analytics_client_common_1.getGlobalScope)();
    var eventListeners = [];
    var addNetworkListener = function (type, handler) {
        if (globalScope) {
            globalScope.addEventListener(type, handler);
            eventListeners.push({
                type: type,
                handler: handler,
            });
        }
    };
    var removeNetworkListeners = function () {
        eventListeners.forEach(function (_a) {
            var type = _a.type, handler = _a.handler;
            if (globalScope) {
                globalScope.removeEventListener(type, handler);
            }
        });
        eventListeners = [];
    };
    var setup = function (config, amplitude) { return tslib_1.__awaiter(_this, void 0, void 0, function () {
        return tslib_1.__generator(this, function (_a) {
            config.offline = !navigator.onLine;
            addNetworkListener('online', function () {
                config.loggerProvider.debug('Network connectivity changed to online.');
                config.offline = false;
                // Flush immediately will cause ERR_NETWORK_CHANGED
                setTimeout(function () {
                    amplitude.flush();
                }, config.flushIntervalMillis);
            });
            addNetworkListener('offline', function () {
                config.loggerProvider.debug('Network connectivity changed to offline.');
                config.offline = true;
            });
            return [2 /*return*/];
        });
    }); };
    var teardown = function () { return tslib_1.__awaiter(_this, void 0, void 0, function () {
        return tslib_1.__generator(this, function (_a) {
            removeNetworkListeners();
            return [2 /*return*/];
        });
    }); };
    return {
        name: name,
        type: type,
        setup: setup,
        teardown: teardown,
    };
};
exports.networkConnectivityCheckerPlugin = networkConnectivityCheckerPlugin;
//# sourceMappingURL=network-connectivity-checker.js.map