import { AmplitudeCore } from '@amplitude/analytics-core';
import { WebAttribution } from '@amplitude/analytics-client-common';
import { BrowserClient, BrowserConfig, BrowserOptions, Event, EventOptions, Identify as IIdentify, Revenue as IRevenue, TransportType, Result } from '@amplitude/analytics-types';
export declare class AmplitudeBrowser extends AmplitudeCore implements BrowserClient {
    config: BrowserConfig;
    previousSessionDeviceId: string | undefined;
    previousSessionUserId: string | undefined;
    webAttribution: WebAttribution | undefined;
    init(apiKey?: string, userIdOrOptions?: string | BrowserOptions, maybeOptions?: BrowserOptions): import("@amplitude/analytics-types").AmplitudeReturn<void>;
    protected _init(options: BrowserOptions & {
        apiKey: string;
    }): Promise<void>;
    getUserId(): string | undefined;
    setUserId(userId: string | undefined): void;
    getDeviceId(): string | undefined;
    setDeviceId(deviceId: string): void;
    reset(): void;
    getSessionId(): number | undefined;
    setSessionId(sessionId: number): import("@amplitude/analytics-types").AmplitudeReturn<void> | import("@amplitude/analytics-types").AmplitudeReturn<Result[]>;
    extendSession(): void;
    setTransport(transport: TransportType): void;
    identify(identify: IIdentify, eventOptions?: EventOptions): import("@amplitude/analytics-types").AmplitudeReturn<Result>;
    groupIdentify(groupType: string, groupName: string | string[], identify: IIdentify, eventOptions?: EventOptions): import("@amplitude/analytics-types").AmplitudeReturn<Result>;
    revenue(revenue: IRevenue, eventOptions?: EventOptions): import("@amplitude/analytics-types").AmplitudeReturn<Result>;
    private trackCampaignEventIfNeeded;
    process(event: Event): Promise<Result>;
    private logBrowserOptions;
}
//# sourceMappingURL=browser-client.d.ts.map