Object.defineProperty(exports, "__esModule", { value: true });
exports.AmplitudeBrowser = void 0;
var tslib_1 = require("tslib");
var analytics_core_1 = require("@amplitude/analytics-core");
var analytics_client_common_1 = require("@amplitude/analytics-client-common");
var analytics_types_1 = require("@amplitude/analytics-types");
var snippet_helper_1 = require("./utils/snippet-helper");
var context_1 = require("./plugins/context");
var config_1 = require("./config");
var plugin_page_view_tracking_browser_1 = require("@amplitude/plugin-page-view-tracking-browser");
var form_interaction_tracking_1 = require("./plugins/form-interaction-tracking");
var file_download_tracking_1 = require("./plugins/file-download-tracking");
var constants_1 = require("./constants");
var det_notification_1 = require("./det-notification");
var network_connectivity_checker_1 = require("./plugins/network-connectivity-checker");
var joined_config_1 = require("./config/joined-config");
var plugin_autocapture_browser_1 = require("@amplitude/plugin-autocapture-browser");
var AmplitudeBrowser = /** @class */ (function (_super) {
    tslib_1.__extends(AmplitudeBrowser, _super);
    function AmplitudeBrowser() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AmplitudeBrowser.prototype.init = function (apiKey, userIdOrOptions, maybeOptions) {
        if (apiKey === void 0) { apiKey = ''; }
        var userId;
        var options;
        if (arguments.length > 2) {
            userId = userIdOrOptions;
            options = maybeOptions;
        }
        else {
            if (typeof userIdOrOptions === 'string') {
                userId = userIdOrOptions;
                options = undefined;
            }
            else {
                userId = userIdOrOptions === null || userIdOrOptions === void 0 ? void 0 : userIdOrOptions.userId;
                options = userIdOrOptions;
            }
        }
        return (0, analytics_core_1.returnWrapper)(this._init(tslib_1.__assign(tslib_1.__assign({}, options), { userId: userId, apiKey: apiKey })));
    };
    AmplitudeBrowser.prototype._init = function (options) {
        var _a, _b, _c;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var browserOptions, joinedConfigGenerator, attributionTrackingOptions, queryParams, querySessionId, connector;
            var _this = this;
            return tslib_1.__generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        // Step 1: Block concurrent initialization
                        if (this.initializing) {
                            return [2 /*return*/];
                        }
                        this.initializing = true;
                        return [4 /*yield*/, (0, config_1.useBrowserConfig)(options.apiKey, options, this)];
                    case 1:
                        browserOptions = _d.sent();
                        if (!options.fetchRemoteConfig) return [3 /*break*/, 4];
                        return [4 /*yield*/, (0, joined_config_1.createBrowserJoinedConfigGenerator)(browserOptions)];
                    case 2:
                        joinedConfigGenerator = _d.sent();
                        return [4 /*yield*/, joinedConfigGenerator.generateJoinedConfig()];
                    case 3:
                        browserOptions = _d.sent();
                        _d.label = 4;
                    case 4: return [4 /*yield*/, _super.prototype._init.call(this, browserOptions)];
                    case 5:
                        _d.sent();
                        this.logBrowserOptions(browserOptions);
                        if (!(0, analytics_client_common_1.isAttributionTrackingEnabled)(this.config.defaultTracking)) return [3 /*break*/, 7];
                        attributionTrackingOptions = (0, analytics_client_common_1.getAttributionTrackingConfig)(this.config);
                        this.webAttribution = new analytics_client_common_1.WebAttribution(attributionTrackingOptions, this.config);
                        // Fetch the current campaign, check if need to track web attribution later
                        return [4 /*yield*/, this.webAttribution.init()];
                    case 6:
                        // Fetch the current campaign, check if need to track web attribution later
                        _d.sent();
                        _d.label = 7;
                    case 7:
                        queryParams = (0, analytics_client_common_1.getQueryParams)();
                        querySessionId = Number.isNaN(Number(queryParams.ampSessionId))
                            ? undefined
                            : Number(queryParams.ampSessionId);
                        this.setSessionId((_c = (_b = (_a = options.sessionId) !== null && _a !== void 0 ? _a : querySessionId) !== null && _b !== void 0 ? _b : this.config.sessionId) !== null && _c !== void 0 ? _c : Date.now());
                        connector = (0, analytics_client_common_1.getAnalyticsConnector)(options.instanceName);
                        connector.identityStore.setIdentity({
                            userId: this.config.userId,
                            deviceId: this.config.deviceId,
                        });
                        if (!(this.config.offline !== analytics_types_1.OfflineDisabled)) return [3 /*break*/, 9];
                        return [4 /*yield*/, this.add((0, network_connectivity_checker_1.networkConnectivityCheckerPlugin)()).promise];
                    case 8:
                        _d.sent();
                        _d.label = 9;
                    case 9: return [4 /*yield*/, this.add(new analytics_core_1.Destination()).promise];
                    case 10:
                        _d.sent();
                        return [4 /*yield*/, this.add(new context_1.Context()).promise];
                    case 11:
                        _d.sent();
                        return [4 /*yield*/, this.add(new analytics_client_common_1.IdentityEventSender()).promise];
                    case 12:
                        _d.sent();
                        // Notify if DET is enabled
                        (0, det_notification_1.detNotify)(this.config);
                        if (!(0, analytics_client_common_1.isFileDownloadTrackingEnabled)(this.config.defaultTracking)) return [3 /*break*/, 14];
                        this.config.loggerProvider.debug('Adding file download tracking plugin');
                        return [4 /*yield*/, this.add((0, file_download_tracking_1.fileDownloadTracking)()).promise];
                    case 13:
                        _d.sent();
                        _d.label = 14;
                    case 14:
                        if (!(0, analytics_client_common_1.isFormInteractionTrackingEnabled)(this.config.defaultTracking)) return [3 /*break*/, 16];
                        this.config.loggerProvider.debug('Adding form interaction plugin');
                        return [4 /*yield*/, this.add((0, form_interaction_tracking_1.formInteractionTracking)()).promise];
                    case 15:
                        _d.sent();
                        _d.label = 16;
                    case 16:
                        if (!(0, analytics_client_common_1.isPageViewTrackingEnabled)(this.config.defaultTracking)) return [3 /*break*/, 18];
                        this.config.loggerProvider.debug('Adding page view tracking plugin');
                        return [4 /*yield*/, this.add((0, plugin_page_view_tracking_browser_1.pageViewTrackingPlugin)((0, analytics_client_common_1.getPageViewTrackingConfig)(this.config))).promise];
                    case 17:
                        _d.sent();
                        _d.label = 18;
                    case 18:
                        if (!(0, analytics_client_common_1.isElementInteractionsEnabled)(this.config.autocapture)) return [3 /*break*/, 20];
                        this.config.loggerProvider.debug('Adding user interactions plugin (autocapture plugin)');
                        return [4 /*yield*/, this.add((0, plugin_autocapture_browser_1.autocapturePlugin)((0, analytics_client_common_1.getElementInteractionsConfig)(this.config))).promise];
                    case 19:
                        _d.sent();
                        _d.label = 20;
                    case 20:
                        this.initializing = false;
                        // Step 6: Run queued dispatch functions
                        return [4 /*yield*/, this.runQueuedFunctions('dispatchQ')];
                    case 21:
                        // Step 6: Run queued dispatch functions
                        _d.sent();
                        // Step 7: Add the event receiver after running remaining queued functions.
                        connector.eventBridge.setEventReceiver(function (event) {
                            void _this.track(event.eventType, event.eventProperties);
                        });
                        return [2 /*return*/];
                }
            });
        });
    };
    AmplitudeBrowser.prototype.getUserId = function () {
        var _a;
        return (_a = this.config) === null || _a === void 0 ? void 0 : _a.userId;
    };
    AmplitudeBrowser.prototype.setUserId = function (userId) {
        if (!this.config) {
            this.q.push(this.setUserId.bind(this, userId));
            return;
        }
        this.config.loggerProvider.debug('function setUserId: ', userId);
        if (userId !== this.config.userId || userId === undefined) {
            this.config.userId = userId;
            (0, analytics_client_common_1.setConnectorUserId)(userId, this.config.instanceName);
        }
    };
    AmplitudeBrowser.prototype.getDeviceId = function () {
        var _a;
        return (_a = this.config) === null || _a === void 0 ? void 0 : _a.deviceId;
    };
    AmplitudeBrowser.prototype.setDeviceId = function (deviceId) {
        if (!this.config) {
            this.q.push(this.setDeviceId.bind(this, deviceId));
            return;
        }
        this.config.loggerProvider.debug('function setDeviceId: ', deviceId);
        this.config.deviceId = deviceId;
        (0, analytics_client_common_1.setConnectorDeviceId)(deviceId, this.config.instanceName);
    };
    AmplitudeBrowser.prototype.reset = function () {
        this.setDeviceId((0, analytics_core_1.UUID)());
        this.setUserId(undefined);
    };
    AmplitudeBrowser.prototype.getSessionId = function () {
        var _a;
        return (_a = this.config) === null || _a === void 0 ? void 0 : _a.sessionId;
    };
    AmplitudeBrowser.prototype.setSessionId = function (sessionId) {
        var _a;
        var promises = [];
        if (!this.config) {
            this.q.push(this.setSessionId.bind(this, sessionId));
            return (0, analytics_core_1.returnWrapper)(Promise.resolve());
        }
        // Prevents starting a new session with the same session ID
        if (sessionId === this.config.sessionId) {
            return (0, analytics_core_1.returnWrapper)(Promise.resolve());
        }
        this.config.loggerProvider.debug('function setSessionId: ', sessionId);
        var previousSessionId = this.getSessionId();
        var lastEventTime = this.config.lastEventTime;
        var lastEventId = (_a = this.config.lastEventId) !== null && _a !== void 0 ? _a : -1;
        this.config.sessionId = sessionId;
        this.config.lastEventTime = undefined;
        this.config.pageCounter = 0;
        if ((0, analytics_client_common_1.isSessionTrackingEnabled)(this.config.defaultTracking)) {
            if (previousSessionId && lastEventTime) {
                promises.push(this.track(constants_1.DEFAULT_SESSION_END_EVENT, undefined, {
                    device_id: this.previousSessionDeviceId,
                    event_id: ++lastEventId,
                    session_id: previousSessionId,
                    time: lastEventTime + 1,
                    user_id: this.previousSessionUserId,
                }).promise);
            }
            this.config.lastEventTime = this.config.sessionId;
        }
        // Fire web attribution event when enable webAttribution tracking
        // 1. has new campaign (call setSessionId from init function)
        // 2. or shouldTrackNewCampaign (call setSessionId from async process(event) when there has new campaign and resetSessionOnNewCampaign = true )
        var isCampaignEventTracked = this.trackCampaignEventIfNeeded(++lastEventId, promises);
        if ((0, analytics_client_common_1.isSessionTrackingEnabled)(this.config.defaultTracking)) {
            promises.push(this.track(constants_1.DEFAULT_SESSION_START_EVENT, undefined, {
                event_id: isCampaignEventTracked ? ++lastEventId : lastEventId,
                session_id: this.config.sessionId,
                time: this.config.lastEventTime,
            }).promise);
        }
        this.previousSessionDeviceId = this.config.deviceId;
        this.previousSessionUserId = this.config.userId;
        return (0, analytics_core_1.returnWrapper)(Promise.all(promises));
    };
    AmplitudeBrowser.prototype.extendSession = function () {
        if (!this.config) {
            this.q.push(this.extendSession.bind(this));
            return;
        }
        this.config.lastEventTime = Date.now();
    };
    AmplitudeBrowser.prototype.setTransport = function (transport) {
        if (!this.config) {
            this.q.push(this.setTransport.bind(this, transport));
            return;
        }
        this.config.transportProvider = (0, config_1.createTransport)(transport);
    };
    AmplitudeBrowser.prototype.identify = function (identify, eventOptions) {
        if ((0, snippet_helper_1.isInstanceProxy)(identify)) {
            var queue = identify._q;
            identify._q = [];
            identify = (0, snippet_helper_1.convertProxyObjectToRealObject)(new analytics_core_1.Identify(), queue);
        }
        if (eventOptions === null || eventOptions === void 0 ? void 0 : eventOptions.user_id) {
            this.setUserId(eventOptions.user_id);
        }
        if (eventOptions === null || eventOptions === void 0 ? void 0 : eventOptions.device_id) {
            this.setDeviceId(eventOptions.device_id);
        }
        return _super.prototype.identify.call(this, identify, eventOptions);
    };
    AmplitudeBrowser.prototype.groupIdentify = function (groupType, groupName, identify, eventOptions) {
        if ((0, snippet_helper_1.isInstanceProxy)(identify)) {
            var queue = identify._q;
            identify._q = [];
            identify = (0, snippet_helper_1.convertProxyObjectToRealObject)(new analytics_core_1.Identify(), queue);
        }
        return _super.prototype.groupIdentify.call(this, groupType, groupName, identify, eventOptions);
    };
    AmplitudeBrowser.prototype.revenue = function (revenue, eventOptions) {
        if ((0, snippet_helper_1.isInstanceProxy)(revenue)) {
            var queue = revenue._q;
            revenue._q = [];
            revenue = (0, snippet_helper_1.convertProxyObjectToRealObject)(new analytics_core_1.Revenue(), queue);
        }
        return _super.prototype.revenue.call(this, revenue, eventOptions);
    };
    AmplitudeBrowser.prototype.trackCampaignEventIfNeeded = function (lastEventId, promises) {
        if (!this.webAttribution || !this.webAttribution.shouldTrackNewCampaign) {
            return false;
        }
        var campaignEvent = this.webAttribution.generateCampaignEvent(lastEventId);
        if (promises) {
            promises.push(this.track(campaignEvent).promise);
        }
        else {
            this.track(campaignEvent);
        }
        this.config.loggerProvider.log('Tracking attribution.');
        return true;
    };
    AmplitudeBrowser.prototype.process = function (event) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var currentTime, isEventInNewSession, shouldSetSessionIdOnNewCampaign;
            return tslib_1.__generator(this, function (_a) {
                currentTime = Date.now();
                isEventInNewSession = (0, analytics_client_common_1.isNewSession)(this.config.sessionTimeout, this.config.lastEventTime);
                shouldSetSessionIdOnNewCampaign = this.webAttribution && this.webAttribution.shouldSetSessionIdOnNewCampaign();
                if (event.event_type !== constants_1.DEFAULT_SESSION_START_EVENT &&
                    event.event_type !== constants_1.DEFAULT_SESSION_END_EVENT &&
                    (!event.session_id || event.session_id === this.getSessionId())) {
                    if (isEventInNewSession || shouldSetSessionIdOnNewCampaign) {
                        this.setSessionId(currentTime);
                        if (shouldSetSessionIdOnNewCampaign) {
                            this.config.loggerProvider.log('Created a new session for new campaign.');
                        }
                    }
                    else if (!isEventInNewSession) {
                        // Web attribution should be tracked during the middle of a session
                        // if there has been a chance in the campaign information.
                        this.trackCampaignEventIfNeeded();
                    }
                }
                return [2 /*return*/, _super.prototype.process.call(this, event)];
            });
        });
    };
    AmplitudeBrowser.prototype.logBrowserOptions = function (browserConfig) {
        try {
            var browserConfigCopy = tslib_1.__assign(tslib_1.__assign({}, browserConfig), { apiKey: browserConfig.apiKey.substring(0, 10) + '********' });
            this.config.loggerProvider.debug('Initialized Amplitude with BrowserConfig:', JSON.stringify(browserConfigCopy));
        }
        catch (e) {
            /* istanbul ignore next */
            this.config.loggerProvider.error('Error logging browser config', e);
        }
    };
    return AmplitudeBrowser;
}(analytics_core_1.AmplitudeCore));
exports.AmplitudeBrowser = AmplitudeBrowser;
//# sourceMappingURL=browser-client.js.map