var _this = this;
Object.defineProperty(exports, "__esModule", { value: true });
exports.stringOrUndefined = exports.formInteractionTracking = void 0;
var tslib_1 = require("tslib");
var constants_1 = require("../constants");
var analytics_client_common_1 = require("@amplitude/analytics-client-common");
var formInteractionTracking = function () {
    var observer;
    var eventListeners = [];
    var addEventListener = function (element, type, handler) {
        element.addEventListener(type, handler);
        eventListeners.push({
            element: element,
            type: type,
            handler: handler,
        });
    };
    var removeClickListeners = function () {
        eventListeners.forEach(function (_a) {
            var element = _a.element, type = _a.type, handler = _a.handler;
            /* istanbul ignore next */
            element === null || element === void 0 ? void 0 : element.removeEventListener(type, handler);
        });
        eventListeners = [];
    };
    var name = '@amplitude/plugin-form-interaction-tracking-browser';
    var type = 'enrichment';
    var setup = function (config, amplitude) { return tslib_1.__awaiter(_this, void 0, void 0, function () {
        var _a;
        return tslib_1.__generator(this, function (_b) {
            // The form interaction plugin observes changes in the dom. For this to work correctly, the observer can only be setup
            // after the body is built. When Amplitud gets initialized in a script tag, the body tag is still unavailable. So register this
            // only after the window is loaded
            /* istanbul ignore next */
            (_a = (0, analytics_client_common_1.getGlobalScope)()) === null || _a === void 0 ? void 0 : _a.addEventListener('load', function () {
                /* istanbul ignore if */
                if (!amplitude) {
                    // TODO: Add required minimum version of @amplitude/analytics-browser
                    config.loggerProvider.warn('Form interaction tracking requires a later version of @amplitude/analytics-browser. Form interaction events are not tracked.');
                    return;
                }
                /* istanbul ignore if */
                if (typeof document === 'undefined') {
                    return;
                }
                var addFormInteractionListener = function (form) {
                    var hasFormChanged = false;
                    addEventListener(form, 'change', function () {
                        var _a;
                        if (!hasFormChanged) {
                            amplitude.track(constants_1.DEFAULT_FORM_START_EVENT, (_a = {},
                                _a[constants_1.FORM_ID] = (0, exports.stringOrUndefined)(form.id),
                                _a[constants_1.FORM_NAME] = (0, exports.stringOrUndefined)(form.name),
                                _a[constants_1.FORM_DESTINATION] = form.action,
                                _a));
                        }
                        hasFormChanged = true;
                    });
                    addEventListener(form, 'submit', function () {
                        var _a, _b;
                        if (!hasFormChanged) {
                            amplitude.track(constants_1.DEFAULT_FORM_START_EVENT, (_a = {},
                                _a[constants_1.FORM_ID] = (0, exports.stringOrUndefined)(form.id),
                                _a[constants_1.FORM_NAME] = (0, exports.stringOrUndefined)(form.name),
                                _a[constants_1.FORM_DESTINATION] = form.action,
                                _a));
                        }
                        amplitude.track(constants_1.DEFAULT_FORM_SUBMIT_EVENT, (_b = {},
                            _b[constants_1.FORM_ID] = (0, exports.stringOrUndefined)(form.id),
                            _b[constants_1.FORM_NAME] = (0, exports.stringOrUndefined)(form.name),
                            _b[constants_1.FORM_DESTINATION] = form.action,
                            _b));
                        hasFormChanged = false;
                    });
                };
                // Adds listener to existing anchor tags
                var forms = Array.from(document.getElementsByTagName('form'));
                forms.forEach(addFormInteractionListener);
                // Adds listener to anchor tags added after initial load
                /* istanbul ignore else */
                if (typeof MutationObserver !== 'undefined') {
                    observer = new MutationObserver(function (mutations) {
                        mutations.forEach(function (mutation) {
                            mutation.addedNodes.forEach(function (node) {
                                if (node.nodeName === 'FORM') {
                                    addFormInteractionListener(node);
                                }
                                if ('querySelectorAll' in node && typeof node.querySelectorAll === 'function') {
                                    Array.from(node.querySelectorAll('form')).map(addFormInteractionListener);
                                }
                            });
                        });
                    });
                    observer.observe(document.body, {
                        subtree: true,
                        childList: true,
                    });
                }
            });
            return [2 /*return*/];
        });
    }); };
    var execute = function (event) { return tslib_1.__awaiter(_this, void 0, void 0, function () { return tslib_1.__generator(this, function (_a) {
        return [2 /*return*/, event];
    }); }); };
    var teardown = function () { return tslib_1.__awaiter(_this, void 0, void 0, function () {
        return tslib_1.__generator(this, function (_a) {
            observer === null || observer === void 0 ? void 0 : observer.disconnect();
            removeClickListeners();
            return [2 /*return*/];
        });
    }); };
    return {
        name: name,
        type: type,
        setup: setup,
        execute: execute,
        teardown: teardown,
    };
};
exports.formInteractionTracking = formInteractionTracking;
var stringOrUndefined = function (name) {
    /* istanbul ignore if */
    if (typeof name !== 'string') {
        // We found instances where the value of `name` is an Element and not a string.
        // Elements may have circular references and would throw an error when passed to `JSON.stringify(...)`.
        // If a non-string value is seen, assume there is no value.
        return undefined;
    }
    return name;
};
exports.stringOrUndefined = stringOrUndefined;
//# sourceMappingURL=form-interaction-tracking.js.map