import { Event, BrowserOptions, BrowserConfig as IBrowserConfig, DefaultTrackingOptions, Storage, TrackingOptions, TransportType, UserSession, Logger as ILogger, LogLevel, Plan, IngestionMetadata, IdentityStorageType, ServerZoneType, OfflineDisabled, AutocaptureOptions } from '@amplitude/analytics-types';
import { Config, MemoryStorage } from '@amplitude/analytics-core';
import { CookieStorage, FetchTransport } from '@amplitude/analytics-client-common';
import { LocalStorage } from './storage/local-storage';
import { SessionStorage } from './storage/session-storage';
import { XHRTransport } from './transports/xhr';
import { SendBeaconTransport } from './transports/send-beacon';
import { CookieOptions } from '@amplitude/analytics-types/lib/esm/config/browser';
import { AmplitudeBrowser } from './browser-client';
export declare class BrowserConfig extends Config implements IBrowserConfig {
    apiKey: string;
    appVersion?: string | undefined;
    cookieOptions: CookieOptions;
    defaultTracking?: boolean | DefaultTrackingOptions | undefined;
    autocapture?: boolean | AutocaptureOptions | undefined;
    flushIntervalMillis: number;
    flushMaxRetries: number;
    flushQueueSize: number;
    identityStorage: IdentityStorageType;
    ingestionMetadata?: IngestionMetadata | undefined;
    instanceName?: string | undefined;
    loggerProvider: ILogger;
    logLevel: LogLevel;
    minIdLength?: number | undefined;
    offline: boolean | typeof OfflineDisabled;
    partnerId?: string | undefined;
    plan?: Plan | undefined;
    serverUrl: string;
    serverZone: ServerZoneType;
    sessionTimeout: number;
    storageProvider: Storage<Event[]>;
    trackingOptions: Required<TrackingOptions>;
    transport: 'fetch' | 'xhr' | 'beacon';
    useBatch: boolean;
    fetchRemoteConfig: boolean;
    protected _cookieStorage: Storage<UserSession>;
    protected _deviceId?: string;
    protected _lastEventId?: number;
    protected _lastEventTime?: number;
    protected _optOut: boolean;
    protected _sessionId?: number;
    protected _userId?: string;
    protected _pageCounter?: number;
    protected _debugLogsEnabled?: boolean;
    constructor(apiKey: string, appVersion?: string | undefined, cookieStorage?: Storage<UserSession>, cookieOptions?: CookieOptions, defaultTracking?: boolean | DefaultTrackingOptions | undefined, autocapture?: boolean | AutocaptureOptions | undefined, deviceId?: string, flushIntervalMillis?: number, flushMaxRetries?: number, flushQueueSize?: number, identityStorage?: IdentityStorageType, ingestionMetadata?: IngestionMetadata | undefined, instanceName?: string | undefined, lastEventId?: number, lastEventTime?: number, loggerProvider?: ILogger, logLevel?: LogLevel, minIdLength?: number | undefined, offline?: boolean | typeof OfflineDisabled, optOut?: boolean, partnerId?: string | undefined, plan?: Plan | undefined, serverUrl?: string, serverZone?: ServerZoneType, sessionId?: number, sessionTimeout?: number, storageProvider?: Storage<Event[]>, trackingOptions?: Required<TrackingOptions>, transport?: 'fetch' | 'xhr' | 'beacon', useBatch?: boolean, fetchRemoteConfig?: boolean, userId?: string, pageCounter?: number, debugLogsEnabled?: boolean);
    get cookieStorage(): Storage<UserSession>;
    set cookieStorage(cookieStorage: Storage<UserSession>);
    get deviceId(): string | undefined;
    set deviceId(deviceId: string | undefined);
    get userId(): string | undefined;
    set userId(userId: string | undefined);
    get sessionId(): number | undefined;
    set sessionId(sessionId: number | undefined);
    get optOut(): boolean;
    set optOut(optOut: boolean);
    get lastEventTime(): number | undefined;
    set lastEventTime(lastEventTime: number | undefined);
    get lastEventId(): number | undefined;
    set lastEventId(lastEventId: number | undefined);
    get pageCounter(): number | undefined;
    set pageCounter(pageCounter: number | undefined);
    set debugLogsEnabled(debugLogsEnabled: boolean | undefined);
    private updateStorage;
}
export declare const useBrowserConfig: (apiKey: string, options: BrowserOptions | undefined, amplitudeInstance: AmplitudeBrowser) => Promise<IBrowserConfig>;
export declare const createCookieStorage: <T>(identityStorage?: IdentityStorageType, cookieOptions?: CookieOptions) => LocalStorage<T> | SessionStorage<T> | MemoryStorage<T> | CookieStorage<T>;
export declare const createTransport: (transport?: TransportType) => XHRTransport | SendBeaconTransport | FetchTransport;
export declare const getTopLevelDomain: (url?: string) => Promise<string>;
//# sourceMappingURL=config.d.ts.map