var analyticsDoNotTrack = (function (exports) {
  'use strict';

  function doNotTrackPlugin() {
    var userConfig = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    return {
      name: 'do-not-track',
      config: Object.assign({}, userConfig),
      initializeStart: function initializeStart(_ref) {
        var abort = _ref.abort,
            config = _ref.config;

        if (doNotTrackEnabled()) {
          return abort('Cancel the initialize call because do-not-track enabled');
        }
      },
      pageStart: function pageStart(_ref2) {
        var abort = _ref2.abort,
            config = _ref2.config;

        if (doNotTrackEnabled()) {
          return abort('Cancel the page call because do-not-track enabled');
        }
      },
      identifyStart: function identifyStart(_ref3) {
        var abort = _ref3.abort,
            config = _ref3.config;

        if (doNotTrackEnabled()) {
          return abort('Cancel the identify call because do-not-track enabled');
        }
      },
      trackStart: function trackStart(_ref4) {
        var abort = _ref4.abort,
            config = _ref4.config;

        if (doNotTrackEnabled()) {
          return abort('Cancel the track call because do-not-track enabled');
        }
      }
    };
  }
  function doNotTrackEnabled() {
    if (typeof window === 'undefined') return false;
    var _window = window,
        doNotTrack = _window.doNotTrack,
        navigator = _window.navigator; // Do Not Track Settings

    var dnt = doNotTrack || navigator.doNotTrack || navigator.msDoNotTrack || msTracking();

    if (!dnt) {
      return false;
    }

    if (dnt === true || dnt === 1 || dnt === 'yes' || typeof dnt === 'string' && dnt.charAt(0) === '1') {
      return true;
    }

    return false;
  }

  function msTracking() {
    var _window2 = window,
        external = _window2.external;
    return typeof external !== 'undefined' && 'msTrackingProtectionEnabled' in external && typeof external.msTrackingProtectionEnabled === 'function' && window.external.msTrackingProtectionEnabled();
  }
  /* server implementation
  function isDoNotTrackEnabled(request) {
    const doNotTrackHeader = request.header('DNT')

    if (!doNotTrackHeader) {
      return false
    }

    if (doNotTrackHeader.charAt(0) === '1') {
      return true
    }

    return false
  }
  */

  exports.default = doNotTrackPlugin;
  exports.doNotTrackEnabled = doNotTrackEnabled;

  return exports;

}({}));
