"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var lists_1 = require("../lists");
// pattern that an emails MUST have
var pattern = /^[a-z0-9!#$%&'*+\-/=?^_`{|}~.]+@([a-z0-9%\-]+\.){1,}([a-z0-9\-]+)?$/i;
// patterns that an email can not have
var negativePatterns = [
    /^[!#$%&'*+\-/=?^_`{|}~.]/,
    /[.]{2,}[a-z0-9!#$%&'*+\-/=?^_`{|}~.]+@/i,
    /\.@/
];
function default_1(str) {
    // general pattern recognition
    var match = str.match(pattern);
    if (match === null)
        return false;
    // doesn't have a negative pattern
    for (var i = negativePatterns.length - 1; i >= 0; i--) {
        if (negativePatterns[i].test(str))
            return false;
    }
    // valid TLD
    var tld = match[2];
    if (!tld)
        return false;
    if (lists_1.tlds.indexOf(tld) === -1)
        return false;
    return true;
}
exports.default = default_1;
