"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 *
 * Options defaulting function
 *
**/
function defaultOptions(options) {
    if (!options) {
        options = {
            attributes: [],
            ips: true,
            emails: true,
            urls: true,
            files: true,
            truncate: Infinity,
            defaultProtocol: "http://",
            list: false
        };
    }
    if (typeof options.attributes !== "object")
        options.attributes = [];
    if (typeof options.ips !== "boolean")
        options.ips = true;
    if (typeof options.emails !== "boolean")
        options.emails = true;
    if (typeof options.urls !== "boolean")
        options.urls = true;
    if (typeof options.files !== "boolean")
        options.files = true;
    if (typeof options.list !== "boolean")
        options.list = false;
    if (typeof options.defaultProtocol !== "string" && typeof options.defaultProtocol !== "function")
        options.defaultProtocol = "http://";
    if (typeof options.truncate !== "number" && (typeof options.truncate !== "object" || options.truncate === null))
        options.truncate = Infinity;
    return options;
}
exports.defaultOptions = defaultOptions;
/**
 *
 * Returns whether passed string
 * can be a valid port number or not
 *
**/
function isPort(value) {
    if (isNaN(Number(value)))
        return false;
    if ((Number(value)) > 65535)
        return false;
    else
        return true;
}
exports.isPort = isPort;
