/*!
 * angular-aside - v1.2.1
 * https://github.com/dbtek/angular-aside
 * 2015-10-06
 * Copyright (c) 2015 İsmail Demirbilek
 * License: MIT
 */
(function () {
  /**
   * @ngdoc overview
   * @name ngAside
   * @description
   * Main module for aside component.
   * @function
   * @author İsmail Demirbilek
   */
  angular.module('ngAside', ['ui.bootstrap.modal']);
}());
(function () {
  angular.module('ngAside').factory('$aside', [
    '$modal',
    function ($modal) {
      var defaults = this.defaults = { placement: 'left' };
      var asideFactory = {
          open: function (config) {
            var options = angular.extend({}, defaults, config);
            // check placement is set correct
            if ([
                'left',
                'right',
                'bottom',
                'top'
              ].indexOf(options.placement) === -1) {
              options.placement = defaults.placement;
            }
            var vertHoriz = [
                'left',
                'right'
              ].indexOf(options.placement) === -1 ? 'vertical' : 'horizontal';
            // set aside classes
            options.windowClass = 'ng-aside ' + vertHoriz + ' ' + options.placement + (options.windowClass ? ' ' + options.windowClass : '');
            delete options.placement;
            return $modal.open(options);
          }
        };
      // create $aside as extended $modal
      var $aside = angular.extend({}, $modal, asideFactory);
      return $aside;
    }
  ]);
}());