"use strict";
var fs = require('fs');
var path = require('path');
var Command = require('ember-cli/lib/models/command');
var stringUtils = require('ember-cli-string-utils');
var lookupCommand = require('ember-cli/lib/cli/lookup-command');
var commandsToIgnore = [
    'easter-egg',
    'destroy',
    'github-pages-deploy' // errors because there is no base github-pages command
];
var HelpCommand = Command.extend({
    name: 'help',
    description: 'Shows help for the CLI',
    works: 'everywhere',
    availableOptions: [],
    run: function (commandOptions, rawArgs) {
        var _this = this;
        var commandFiles = fs.readdirSync(__dirname)
            .filter(function (file) { return file.match(/\.(j|t)s$/) && !file.match(/\.d.ts$/); })
            .map(function (file) { return path.parse(file).name; })
            .map(function (file) { return file.toLowerCase(); });
        commandFiles = commandFiles.filter(function (file) {
            return commandsToIgnore.indexOf(file) < 0;
        });
        var commandMap = commandFiles.reduce(function (acc, curr) {
            var classifiedName = stringUtils.classify(curr);
            var defaultImport = require("./" + curr).default;
            acc[classifiedName] = defaultImport;
            return acc;
        }, {});
        commandFiles.forEach(function (cmd) {
            var Command = lookupCommand(commandMap, cmd);
            var command = new Command({
                ui: _this.ui,
                project: _this.project,
                commands: _this.commands,
                tasks: _this.tasks
            });
            if (rawArgs.length > 0) {
                if (cmd === rawArgs[0]) {
                    _this.ui.writeLine(command.printDetailedHelp(commandOptions));
                }
            }
            else {
                _this.ui.writeLine(command.printBasicHelp(commandOptions));
            }
        });
    }
});
HelpCommand.overrideCore = true;
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = HelpCommand;
//# sourceMappingURL=/usr/local/google/home/arick/angular-cli/packages/angular-cli/commands/help.js.map