"use strict";
var webpack = require('webpack');
var path = require('path');
var glob_copy_webpack_plugin_1 = require('../plugins/glob-copy-webpack-plugin');
var package_chunk_sort_1 = require('../utilities/package-chunk-sort');
var base_href_webpack_1 = require('@angular-cli/base-href-webpack');
var ProgressPlugin = require('webpack/lib/ProgressPlugin');
var HtmlWebpackPlugin = require('html-webpack-plugin');
var autoprefixer = require('autoprefixer');
function getWebpackCommonConfig(projectRoot, environment, appConfig, baseHref, sourcemap, vendorChunk, verbose, progress) {
    var appRoot = path.resolve(projectRoot, appConfig.root);
    var appMain = path.resolve(appRoot, appConfig.main);
    var nodeModules = path.resolve(projectRoot, 'node_modules');
    var styles = appConfig.styles
        ? appConfig.styles.map(function (style) { return path.resolve(appRoot, style); })
        : [];
    var scripts = appConfig.scripts
        ? appConfig.scripts.map(function (script) { return path.resolve(appRoot, script); })
        : [];
    var extraPlugins = [];
    var entry = {
        main: [appMain]
    };
    // Only add styles/scripts if there's actually entries there
    if (appConfig.styles.length > 0) {
        entry['styles'] = styles;
    }
    if (appConfig.scripts.length > 0) {
        entry['scripts'] = scripts;
    }
    if (vendorChunk) {
        extraPlugins.push(new webpack.optimize.CommonsChunkPlugin({
            name: 'vendor',
            chunks: ['main'],
            minChunks: function (module) { return module.userRequest && module.userRequest.startsWith(nodeModules); }
        }));
    }
    if (progress) {
        extraPlugins.push(new ProgressPlugin({
            profile: verbose,
            colors: true
        }));
    }
    return {
        devtool: sourcemap ? 'source-map' : false,
        resolve: {
            extensions: ['.ts', '.js'],
            modules: [nodeModules]
        },
        context: path.resolve(__dirname, './'),
        entry: entry,
        output: {
            path: path.resolve(projectRoot, appConfig.outDir),
            filename: '[name].bundle.js',
            sourceMapFilename: '[name].bundle.map',
            chunkFilename: '[id].chunk.js'
        },
        module: {
            rules: [
                {
                    enforce: 'pre',
                    test: /\.js$/,
                    loader: 'source-map-loader',
                    exclude: [nodeModules]
                },
                // in main, load css as raw text
                {
                    exclude: styles,
                    test: /\.css$/,
                    loaders: ['raw-loader', 'postcss-loader']
                }, {
                    exclude: styles,
                    test: /\.styl$/,
                    loaders: ['raw-loader', 'postcss-loader', 'stylus-loader'] },
                {
                    exclude: styles,
                    test: /\.less$/,
                    loaders: ['raw-loader', 'postcss-loader', 'less-loader']
                }, {
                    exclude: styles,
                    test: /\.scss$|\.sass$/,
                    loaders: ['raw-loader', 'postcss-loader', 'sass-loader']
                },
                // load global scripts using script-loader
                { include: scripts, test: /\.js$/, loader: 'script-loader' },
                { test: /\.json$/, loader: 'json-loader' },
                { test: /\.(jpg|png|gif)$/, loader: 'url-loader?limit=10000' },
                { test: /\.html$/, loader: 'raw-loader' },
                { test: /\.(otf|ttf|woff|woff2)$/, loader: 'url-loader?limit=10000' },
                { test: /\.(eot|svg)$/, loader: 'file-loader' }
            ]
        },
        plugins: [
            new HtmlWebpackPlugin({
                template: path.resolve(appRoot, appConfig.index),
                filename: path.resolve(appConfig.outDir, appConfig.index),
                chunksSortMode: package_chunk_sort_1.packageChunkSort(['inline', 'styles', 'scripts', 'vendor', 'main'])
            }),
            new base_href_webpack_1.BaseHrefWebpackPlugin({
                baseHref: baseHref
            }),
            new webpack.NormalModuleReplacementPlugin(
            // This plugin is responsible for swapping the environment files.
            // Since it takes a RegExp as first parameter, we need to escape the path.
            // See https://webpack.github.io/docs/list-of-plugins.html#normalmodulereplacementplugin
            new RegExp(path.resolve(appRoot, appConfig.environments['source'])
                .replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, '\\$&')), path.resolve(appRoot, appConfig.environments[environment])),
            new webpack.optimize.CommonsChunkPlugin({
                minChunks: Infinity,
                name: 'inline'
            }),
            new glob_copy_webpack_plugin_1.GlobCopyWebpackPlugin({
                patterns: appConfig.assets,
                globOptions: { cwd: appRoot, dot: true, ignore: '**/.gitkeep' }
            }),
            new webpack.LoaderOptionsPlugin({
                test: /\.(css|scss|sass|less|styl)$/,
                options: {
                    postcss: [autoprefixer()]
                },
            })
        ].concat(extraPlugins),
        node: {
            fs: 'empty',
            global: true,
            crypto: 'empty',
            tls: 'empty',
            net: 'empty',
            process: true,
            module: false,
            clearImmediate: false,
            setImmediate: false
        }
    };
}
exports.getWebpackCommonConfig = getWebpackCommonConfig;
//# sourceMappingURL=/Users/hansl/Sources/angular-cli/packages/angular-cli/models/webpack-build-common.js.map