"use strict";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@angular-devkit/core");
const rxjs_1 = require("rxjs");
const operators_1 = require("rxjs/operators");
const src_1 = require("../src");
exports.DefaultTimeout = 45000;
function runTargetSpec(host, targetSpec, overrides = {}, timeout = exports.DefaultTimeout, logger = new core_1.logging.NullLogger()) {
    targetSpec = Object.assign({}, targetSpec, { overrides });
    const workspaceFile = core_1.normalize('angular.json');
    const workspace = new core_1.experimental.workspace.Workspace(host.root(), host);
    // Emit when runArchitect$ completes or errors.
    // TODO: There must be a better way of doing this...
    let finalizeCB = () => { };
    const runArchitectFinalize$ = new rxjs_1.Observable(obs => {
        finalizeCB = () => obs.next();
    });
    // Load the workspace from the root of the host, then run a target.
    const runArchitect$ = workspace.loadWorkspaceFromHost(workspaceFile).pipe(operators_1.concatMap(ws => new src_1.Architect(ws).loadArchitect()), operators_1.concatMap(arch => arch.run(arch.getBuilderConfiguration(targetSpec), { logger })), operators_1.finalize(() => finalizeCB()));
    // Error out after the timeout if runArchitect$ hasn't finalized.
    const timeout$ = rxjs_1.timer(timeout).pipe(operators_1.takeUntil(runArchitectFinalize$), operators_1.concatMapTo(rxjs_1.throwError(`runTargetSpec timeout (${timeout}) reached.`)));
    return rxjs_1.merge(timeout$, runArchitect$);
}
exports.runTargetSpec = runTargetSpec;
//# sourceMappingURL=data:application/json;base64,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