"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
// This matches a comment left by the build-optimizer that contains pure import paths
const importCommentRegex = /\/\*\* PURE_IMPORTS_START (\S+) PURE_IMPORTS_END \*\//mg;
// TODO: handle sourcemaps
function purify(content) {
    const pureImportMatches = getMatches(content, importCommentRegex, 1).join('|');
    const newContent = content
        .replace(new RegExp(`(_(${pureImportMatches})__ = )(__webpack_require__\\(\\S+\\);)`, 'mg'), '$1/*@__PURE__*/$3')
        .replace(new RegExp(`(_(${pureImportMatches})___default = )(__webpack_require__\\.\\w\\(\\S+\\);)`, 'mg'), '$1/*@__PURE__*/$3')
        .replace(/\w*__WEBPACK_IMPORTED_MODULE_\d+__angular_core__\["\w+" \/\* (ɵccf|ɵcmf|ɵcrt) \*\/\]\(/mg, '/*@__PURE__*/$&')
        .replace(/new \w*__WEBPACK_IMPORTED_MODULE_\d+__angular_core__\["\w+" \/\* NgModuleFactory \*\/\]/mg, '/*@__PURE__*/$&');
    return newContent;
}
exports.purify = purify;
function getMatches(str, regex, index) {
    let matches = [];
    let match;
    // tslint:disable-next-line:no-conditional-assignment
    while (match = regex.exec(str)) {
        matches = matches.concat(match[index].split(','));
    }
    return matches;
}
//# sourceMappingURL=data:application/json;base64,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