"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const webpack_sources_1 = require("webpack-sources");
const purify_1 = require("./purify");
class PurifyPlugin {
    constructor() { }
    apply(compiler) {
        // tslint:disable-next-line:no-any
        compiler.plugin('compilation', (compilation) => {
            compilation.plugin('optimize-chunk-assets', (chunks, callback) => {
                chunks.forEach((chunk) => {
                    chunk.files
                        .filter((fileName) => fileName.endsWith('.js'))
                        .forEach((fileName) => {
                        const purified = purify_1.purify(compilation.assets[fileName].source());
                        compilation.assets[fileName] = new webpack_sources_1.ConcatSource(new webpack_sources_1.RawSource(purified));
                    });
                });
                callback();
            });
        });
    }
}
exports.PurifyPlugin = PurifyPlugin;
//# sourceMappingURL=data:application/json;base64,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