#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = require("fs");
const path_1 = require("path");
const build_optimizer_1 = require("./build-optimizer");
if (process.argv.length < 3 || process.argv.length > 4) {
    throw new Error(`
    build-optimizer should be called with either one or two arguments:

      build-optimizer input.js
      build-optimizer input.js output.js
  `);
}
const currentDir = process.cwd();
const inputFile = process.argv[2];
const tsOrJsRegExp = /\.(j|t)s$/;
if (!inputFile.match(tsOrJsRegExp)) {
    throw new Error(`Input file must be .js or .ts.`);
}
// Use provided output file, or add the .bo suffix before the extension.
const outputFile = process.argv[3] || inputFile.replace(tsOrJsRegExp, (subStr) => `.bo${subStr}`);
const boOutput = build_optimizer_1.buildOptimizer({
    inputFilePath: path_1.join(currentDir, inputFile),
    outputFilePath: path_1.join(currentDir, outputFile),
    emitSourceMap: true,
});
if (boOutput.emitSkipped) {
    console.log('Nothing to emit.');
}
else {
    fs_1.writeFileSync(path_1.join(currentDir, outputFile), boOutput.content);
    fs_1.writeFileSync(path_1.join(currentDir, `${outputFile}.map`), JSON.stringify(boOutput.sourceMap));
    console.log('Emitted:');
    console.log(`  ${outputFile}`);
    console.log(`  ${outputFile}.map`);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xpLmpzIiwic291cmNlUm9vdCI6Ii9Vc2Vycy9oYW5zbC9Tb3VyY2VzL2hhbnNsL2RldmtpdC8iLCJzb3VyY2VzIjpbInBhY2thZ2VzL2FuZ3VsYXJfZGV2a2l0L2J1aWxkX29wdGltaXplci9zcmMvYnVpbGQtb3B0aW1pemVyL2NsaS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFRQSwyQkFBbUM7QUFDbkMsK0JBQTRCO0FBQzVCLHVEQUFtRDtBQUduRCxFQUFFLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLE1BQU0sR0FBRyxDQUFDLElBQUksT0FBTyxDQUFDLElBQUksQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUN2RCxNQUFNLElBQUksS0FBSyxDQUFDOzs7OztHQUtmLENBQUMsQ0FBQztBQUNMLENBQUM7QUFFRCxNQUFNLFVBQVUsR0FBRyxPQUFPLENBQUMsR0FBRyxFQUFFLENBQUM7QUFFakMsTUFBTSxTQUFTLEdBQUcsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztBQUNsQyxNQUFNLFlBQVksR0FBRyxXQUFXLENBQUM7QUFFakMsRUFBRSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNuQyxNQUFNLElBQUksS0FBSyxDQUFDLGdDQUFnQyxDQUFDLENBQUM7QUFDcEQsQ0FBQztBQUVELHdFQUF3RTtBQUN4RSxNQUFNLFVBQVUsR0FBRyxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxJQUFJLFNBQVMsQ0FBQyxPQUFPLENBQUMsWUFBWSxFQUFFLENBQUMsTUFBTSxFQUFFLEVBQUUsQ0FBQyxNQUFNLE1BQU0sRUFBRSxDQUFDLENBQUM7QUFFbEcsTUFBTSxRQUFRLEdBQUcsZ0NBQWMsQ0FBQztJQUM5QixhQUFhLEVBQUUsV0FBSSxDQUFDLFVBQVUsRUFBRSxTQUFTLENBQUM7SUFDMUMsY0FBYyxFQUFFLFdBQUksQ0FBQyxVQUFVLEVBQUUsVUFBVSxDQUFDO0lBQzVDLGFBQWEsRUFBRSxJQUFJO0NBQ3BCLENBQUMsQ0FBQztBQUVILEVBQUUsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ3pCLE9BQU8sQ0FBQyxHQUFHLENBQUMsa0JBQWtCLENBQUMsQ0FBQztBQUNsQyxDQUFDO0FBQUMsSUFBSSxDQUFDLENBQUM7SUFDTixrQkFBYSxDQUFDLFdBQUksQ0FBQyxVQUFVLEVBQUUsVUFBVSxDQUFDLEVBQUUsUUFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0lBQzlELGtCQUFhLENBQUMsV0FBSSxDQUFDLFVBQVUsRUFBRSxHQUFHLFVBQVUsTUFBTSxDQUFDLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUN6RixPQUFPLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ3hCLE9BQU8sQ0FBQyxHQUFHLENBQUMsS0FBSyxVQUFVLEVBQUUsQ0FBQyxDQUFDO0lBQy9CLE9BQU8sQ0FBQyxHQUFHLENBQUMsS0FBSyxVQUFVLE1BQU0sQ0FBQyxDQUFDO0FBQ3JDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIjIS91c3IvYmluL2VudiBub2RlXG4vKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgR29vZ2xlIEluYy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuICovXG5pbXBvcnQgeyB3cml0ZUZpbGVTeW5jIH0gZnJvbSAnZnMnO1xuaW1wb3J0IHsgam9pbiB9IGZyb20gJ3BhdGgnO1xuaW1wb3J0IHsgYnVpbGRPcHRpbWl6ZXIgfSBmcm9tICcuL2J1aWxkLW9wdGltaXplcic7XG5cblxuaWYgKHByb2Nlc3MuYXJndi5sZW5ndGggPCAzIHx8IHByb2Nlc3MuYXJndi5sZW5ndGggPiA0KSB7XG4gIHRocm93IG5ldyBFcnJvcihgXG4gICAgYnVpbGQtb3B0aW1pemVyIHNob3VsZCBiZSBjYWxsZWQgd2l0aCBlaXRoZXIgb25lIG9yIHR3byBhcmd1bWVudHM6XG5cbiAgICAgIGJ1aWxkLW9wdGltaXplciBpbnB1dC5qc1xuICAgICAgYnVpbGQtb3B0aW1pemVyIGlucHV0LmpzIG91dHB1dC5qc1xuICBgKTtcbn1cblxuY29uc3QgY3VycmVudERpciA9IHByb2Nlc3MuY3dkKCk7XG5cbmNvbnN0IGlucHV0RmlsZSA9IHByb2Nlc3MuYXJndlsyXTtcbmNvbnN0IHRzT3JKc1JlZ0V4cCA9IC9cXC4oanx0KXMkLztcblxuaWYgKCFpbnB1dEZpbGUubWF0Y2godHNPckpzUmVnRXhwKSkge1xuICB0aHJvdyBuZXcgRXJyb3IoYElucHV0IGZpbGUgbXVzdCBiZSAuanMgb3IgLnRzLmApO1xufVxuXG4vLyBVc2UgcHJvdmlkZWQgb3V0cHV0IGZpbGUsIG9yIGFkZCB0aGUgLmJvIHN1ZmZpeCBiZWZvcmUgdGhlIGV4dGVuc2lvbi5cbmNvbnN0IG91dHB1dEZpbGUgPSBwcm9jZXNzLmFyZ3ZbM10gfHwgaW5wdXRGaWxlLnJlcGxhY2UodHNPckpzUmVnRXhwLCAoc3ViU3RyKSA9PiBgLmJvJHtzdWJTdHJ9YCk7XG5cbmNvbnN0IGJvT3V0cHV0ID0gYnVpbGRPcHRpbWl6ZXIoe1xuICBpbnB1dEZpbGVQYXRoOiBqb2luKGN1cnJlbnREaXIsIGlucHV0RmlsZSksXG4gIG91dHB1dEZpbGVQYXRoOiBqb2luKGN1cnJlbnREaXIsIG91dHB1dEZpbGUpLFxuICBlbWl0U291cmNlTWFwOiB0cnVlLFxufSk7XG5cbmlmIChib091dHB1dC5lbWl0U2tpcHBlZCkge1xuICBjb25zb2xlLmxvZygnTm90aGluZyB0byBlbWl0LicpO1xufSBlbHNlIHtcbiAgd3JpdGVGaWxlU3luYyhqb2luKGN1cnJlbnREaXIsIG91dHB1dEZpbGUpLCBib091dHB1dC5jb250ZW50KTtcbiAgd3JpdGVGaWxlU3luYyhqb2luKGN1cnJlbnREaXIsIGAke291dHB1dEZpbGV9Lm1hcGApLCBKU09OLnN0cmluZ2lmeShib091dHB1dC5zb3VyY2VNYXApKTtcbiAgY29uc29sZS5sb2coJ0VtaXR0ZWQ6Jyk7XG4gIGNvbnNvbGUubG9nKGAgICR7b3V0cHV0RmlsZX1gKTtcbiAgY29uc29sZS5sb2coYCAgJHtvdXRwdXRGaWxlfS5tYXBgKTtcbn1cbiJdfQ==