"use strict";
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const interface_1 = require("./tree/interface");
const static_1 = require("./tree/static");
var exception_1 = require("./exception/exception");
exports.SchematicsError = exception_1.SchematicsError;
__export(require("./tree/action"));
__export(require("./engine/collection"));
__export(require("./engine/engine"));
__export(require("./tree/interface"));
__export(require("./rules/base"));
__export(require("./rules/move"));
__export(require("./rules/random"));
__export(require("./rules/schematic"));
__export(require("./rules/template"));
__export(require("./rules/url"));
__export(require("./tree/empty"));
__export(require("./tree/filesystem"));
__export(require("./tree/memory-host"));
__export(require("./tree/virtual"));
__export(require("./engine/schematic"));
__export(require("./sink/dryrun"));
var filesystem_1 = require("./sink/filesystem");
exports.FileSystemSink = filesystem_1.FileSystemSink;
__export(require("./utility/path"));
exports.Tree = {
    empty() { return static_1.empty(); },
    branch(tree) { return static_1.branch(tree); },
    merge(tree, other, strategy = interface_1.MergeStrategy.Default) {
        return static_1.merge(tree, other, strategy);
    },
    partition(tree, predicate) {
        return static_1.partition(tree, predicate);
    },
    optimize(tree) { return static_1.optimize(tree); },
};
//# sourceMappingURL=data:application/json;base64,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