"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const Observable_1 = require("rxjs/Observable");
const static_1 = require("../tree/static");
/**
 * Run a schematic from a separate collection.
 *
 * @param collectionName The name of the collection that contains the schematic to run.
 * @param schematicName The name of the schematic to run.
 * @param options The options to pass as input to the RuleFactory.
 */
function externalSchematic(collectionName, schematicName, options) {
    return (input, context) => {
        const collection = context.engine.createCollection(collectionName);
        const schematic = collection.createSchematic(schematicName);
        return schematic.call(options, Observable_1.Observable.of(static_1.branch(input)));
    };
}
exports.externalSchematic = externalSchematic;
/**
 * Run a schematic from the same collection.
 *
 * @param schematicName The name of the schematic to run.
 * @param options The options to pass as input to the RuleFactory.
 */
function schematic(schematicName, options) {
    return (input, context) => {
        const collection = context.schematic.collection;
        const schematic = collection.createSchematic(schematicName);
        return schematic.call(options, Observable_1.Observable.of(static_1.branch(input)));
    };
}
exports.schematic = schematic;
//# sourceMappingURL=data:application/json;base64,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