"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class SimpleFileEntry {
    constructor(_path, _content) {
        this._path = _path;
        this._content = _content;
    }
    get path() { return this._path; }
    get content() { return this._content; }
}
exports.SimpleFileEntry = SimpleFileEntry;
class LazyFileEntry {
    constructor(_path, _load) {
        this._path = _path;
        this._load = _load;
        this._content = null;
    }
    get path() { return this._path; }
    get content() { return this._content || (this._content = this._load(this._path)); }
}
exports.LazyFileEntry = LazyFileEntry;
//# sourceMappingURL=data:application/json;base64,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