"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const virtual_1 = require("./virtual");
class FilteredTree extends virtual_1.VirtualTree {
    constructor(tree, filter = () => true) {
        super();
        const virtualTree = (tree instanceof virtual_1.VirtualTree
            ? tree : virtual_1.VirtualTree.optimize(tree));
        const root = virtualTree.root;
        const staging = virtualTree.staging;
        [...root.entries()].forEach(([path, entry]) => {
            if (filter(path, entry)) {
                this._root.set(path, entry);
            }
        });
        [...staging.entries()].forEach(([path, entry]) => {
            if (filter(path, entry)) {
                this._cacheMap.set(path, entry);
            }
        });
        virtualTree.actions.forEach(action => {
            if (this._cacheMap.has(action.path) || this._root.has(action.path)) {
                this._actions.push(action);
            }
        });
    }
}
exports.FilteredTree = FilteredTree;
//# sourceMappingURL=data:application/json;base64,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