"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var MergeStrategy;
(function (MergeStrategy) {
    MergeStrategy[MergeStrategy["AllowOverwriteConflict"] = 2] = "AllowOverwriteConflict";
    MergeStrategy[MergeStrategy["AllowCreationConflict"] = 4] = "AllowCreationConflict";
    MergeStrategy[MergeStrategy["AllowDeleteConflict"] = 8] = "AllowDeleteConflict";
    // Uses the default strategy.
    MergeStrategy[MergeStrategy["Default"] = 0] = "Default";
    // Error out if 2 files have the same path. It is useful to have a different value than
    // Default in this case as the tooling Default might differ.
    MergeStrategy[MergeStrategy["Error"] = 1] = "Error";
    // Only content conflicts are overwritten.
    MergeStrategy[MergeStrategy["ContentOnly"] = 2] = "ContentOnly";
    // Overwrite everything with the latest change.
    MergeStrategy[MergeStrategy["Overwrite"] = 14] = "Overwrite";
})(MergeStrategy = exports.MergeStrategy || (exports.MergeStrategy = {}));
//# sourceMappingURL=data:application/json;base64,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