"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const path_1 = require("../utility/path");
class InMemoryFileSystemTreeHost {
    constructor(content) {
        this._content = Object.create(null);
        Object.keys(content).forEach(path => {
            path = path_1.normalizePath(path);
            this._content[path] = new Buffer(content[path]);
        });
        this._files = Object.keys(this._content);
    }
    listDirectory(path) {
        path = path_1.normalizePath(path).replace(/\/?$/, '/');
        return Object.keys(this._files
            .filter(p => p.startsWith(path))
            .map(p => p.substr(path.length))
            .map(p => p.replace(/\/.*$/, ''))
            .reduce((acc, p) => (acc[p] = true, acc), {})).sort();
    }
    isDirectory(path) {
        path = path_1.normalizePath(path);
        return path == '/' || this._files.some(p => p.split('/').slice(0, -1).join('/') == path);
    }
    readFile(path) {
        path = path_1.normalizePath(path);
        return this._content[path] || new Buffer('');
    }
    join(path1, path2) {
        return path_1.normalizePath(path1 + '/' + path2);
    }
}
exports.InMemoryFileSystemTreeHost = InMemoryFileSystemTreeHost;
//# sourceMappingURL=data:application/json;base64,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