"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const filtered_1 = require("./filtered");
const interface_1 = require("./interface");
const virtual_1 = require("./virtual");
function empty() { return new virtual_1.VirtualTree(); }
exports.empty = empty;
function branch(tree) {
    return virtual_1.VirtualTree.branch(tree);
}
exports.branch = branch;
function merge(tree, other, strategy = interface_1.MergeStrategy.Default) {
    return virtual_1.VirtualTree.merge(tree, other, strategy);
}
exports.merge = merge;
function partition(tree, predicate) {
    return [
        new filtered_1.FilteredTree(tree, predicate),
        new filtered_1.FilteredTree(tree, (path, entry) => !predicate(path, entry)),
    ];
}
exports.partition = partition;
function optimize(tree) {
    return virtual_1.VirtualTree.optimize(tree);
}
exports.optimize = optimize;
//# sourceMappingURL=data:application/json;base64,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