"use strict";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
class LinkedList {
    constructor(_head) {
        this._head = _head;
    }
    get(l) {
        let c = this._head;
        while (c && l > 0) {
            l--;
            c = c.next;
        }
        return c;
    }
    get head() { return this._head; }
    get length() {
        let c = this._head;
        let i = 0;
        while (c) {
            i++;
            c = c.next;
        }
        return i;
    }
    reduce(accumulator, seed) {
        let c = this._head;
        let acc = seed;
        let i = 0;
        while (c) {
            acc = accumulator(acc, c, i);
            i++;
            c = c.next;
        }
        return acc;
    }
    find(predicate) {
        let c = this._head;
        let i = 0;
        while (c) {
            if (predicate(c, i)) {
                break;
            }
            i++;
            c = c.next;
        }
        return c;
    }
    forEach(visitor) {
        let c = this._head;
        let i = 0;
        while (c) {
            visitor(c, i);
            i++;
            c = c.next;
        }
    }
}
exports.LinkedList = LinkedList;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGlua2VkLWxpc3QuanMiLCJzb3VyY2VSb290IjoiL1VzZXJzL2hhbnNsL1NvdXJjZXMvZGV2a2l0LyIsInNvdXJjZXMiOlsicGFja2FnZXMvYW5ndWxhcl9kZXZraXQvc2NoZW1hdGljcy9zcmMvdXRpbGl0eS9saW5rZWQtbGlzdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7Ozs7OztHQU1HOztBQUVIO0lBQ0UsWUFBb0IsS0FBUTtRQUFSLFVBQUssR0FBTCxLQUFLLENBQUc7SUFBRyxDQUFDO0lBRWhDLEdBQUcsQ0FBQyxDQUFTO1FBQ1gsSUFBSSxDQUFDLEdBQWEsSUFBSSxDQUFDLEtBQUssQ0FBQztRQUM3QixPQUFPLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUM7WUFDbEIsQ0FBQyxFQUFFLENBQUM7WUFDSixDQUFDLEdBQUcsQ0FBQyxDQUFDLElBQUksQ0FBQztRQUNiLENBQUM7UUFFRCxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQ1gsQ0FBQztJQUVELElBQUksSUFBSSxLQUFLLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNqQyxJQUFJLE1BQU07UUFDUixJQUFJLENBQUMsR0FBYSxJQUFJLENBQUMsS0FBSyxDQUFDO1FBQzdCLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUNWLE9BQU8sQ0FBQyxFQUFFLENBQUM7WUFDVCxDQUFDLEVBQUUsQ0FBQztZQUNKLENBQUMsR0FBRyxDQUFDLENBQUMsSUFBSSxDQUFDO1FBQ2IsQ0FBQztRQUVELE1BQU0sQ0FBQyxDQUFDLENBQUM7SUFDWCxDQUFDO0lBRUQsTUFBTSxDQUFJLFdBQW9ELEVBQUUsSUFBTztRQUNyRSxJQUFJLENBQUMsR0FBYSxJQUFJLENBQUMsS0FBSyxDQUFDO1FBQzdCLElBQUksR0FBRyxHQUFHLElBQUksQ0FBQztRQUNmLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUNWLE9BQU8sQ0FBQyxFQUFFLENBQUM7WUFDVCxHQUFHLEdBQUcsV0FBVyxDQUFDLEdBQUcsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7WUFDN0IsQ0FBQyxFQUFFLENBQUM7WUFDSixDQUFDLEdBQUcsQ0FBQyxDQUFDLElBQUksQ0FBQztRQUNiLENBQUM7UUFFRCxNQUFNLENBQUMsR0FBRyxDQUFDO0lBQ2IsQ0FBQztJQUVELElBQUksQ0FBQyxTQUFnRDtRQUNuRCxJQUFJLENBQUMsR0FBYSxJQUFJLENBQUMsS0FBSyxDQUFDO1FBQzdCLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUNWLE9BQU8sQ0FBQyxFQUFFLENBQUM7WUFDVCxFQUFFLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztnQkFDcEIsS0FBSyxDQUFDO1lBQ1IsQ0FBQztZQUNELENBQUMsRUFBRSxDQUFDO1lBQ0osQ0FBQyxHQUFHLENBQUMsQ0FBQyxJQUFJLENBQUM7UUFDYixDQUFDO1FBRUQsTUFBTSxDQUFDLENBQUMsQ0FBQztJQUNYLENBQUM7SUFFRCxPQUFPLENBQUMsT0FBMkM7UUFDakQsSUFBSSxDQUFDLEdBQWEsSUFBSSxDQUFDLEtBQUssQ0FBQztRQUM3QixJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDVixPQUFPLENBQUMsRUFBRSxDQUFDO1lBQ1QsT0FBTyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztZQUNkLENBQUMsRUFBRSxDQUFDO1lBQ0osQ0FBQyxHQUFHLENBQUMsQ0FBQyxJQUFJLENBQUM7UUFDYixDQUFDO0lBQ0gsQ0FBQztDQUNGO0FBN0RELGdDQTZEQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBHb29nbGUgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0IGh0dHBzOi8vYW5ndWxhci5pby9saWNlbnNlXG4gKi9cblxuZXhwb3J0IGNsYXNzIExpbmtlZExpc3Q8VCBleHRlbmRzIHtuZXh0OiBUIHwgbnVsbH0+IHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSBfaGVhZDogVCkge31cblxuICBnZXQobDogbnVtYmVyKSB7XG4gICAgbGV0IGM6IFQgfCBudWxsID0gdGhpcy5faGVhZDtcbiAgICB3aGlsZSAoYyAmJiBsID4gMCkge1xuICAgICAgbC0tO1xuICAgICAgYyA9IGMubmV4dDtcbiAgICB9XG5cbiAgICByZXR1cm4gYztcbiAgfVxuXG4gIGdldCBoZWFkKCkgeyByZXR1cm4gdGhpcy5faGVhZDsgfVxuICBnZXQgbGVuZ3RoKCkge1xuICAgIGxldCBjOiBUIHwgbnVsbCA9IHRoaXMuX2hlYWQ7XG4gICAgbGV0IGkgPSAwO1xuICAgIHdoaWxlIChjKSB7XG4gICAgICBpKys7XG4gICAgICBjID0gYy5uZXh0O1xuICAgIH1cblxuICAgIHJldHVybiBpO1xuICB9XG5cbiAgcmVkdWNlPFI+KGFjY3VtdWxhdG9yOiAoYWNjOiBSLCB2YWx1ZTogVCwgaW5kZXg/OiBudW1iZXIpID0+IFIsIHNlZWQ6IFIpIHtcbiAgICBsZXQgYzogVCB8IG51bGwgPSB0aGlzLl9oZWFkO1xuICAgIGxldCBhY2MgPSBzZWVkO1xuICAgIGxldCBpID0gMDtcbiAgICB3aGlsZSAoYykge1xuICAgICAgYWNjID0gYWNjdW11bGF0b3IoYWNjLCBjLCBpKTtcbiAgICAgIGkrKztcbiAgICAgIGMgPSBjLm5leHQ7XG4gICAgfVxuXG4gICAgcmV0dXJuIGFjYztcbiAgfVxuXG4gIGZpbmQocHJlZGljYXRlOiAodmFsdWU6IFQsIGluZGV4PzogbnVtYmVyKSA9PiBib29sZWFuKSB7XG4gICAgbGV0IGM6IFQgfCBudWxsID0gdGhpcy5faGVhZDtcbiAgICBsZXQgaSA9IDA7XG4gICAgd2hpbGUgKGMpIHtcbiAgICAgIGlmIChwcmVkaWNhdGUoYywgaSkpIHtcbiAgICAgICAgYnJlYWs7XG4gICAgICB9XG4gICAgICBpKys7XG4gICAgICBjID0gYy5uZXh0O1xuICAgIH1cblxuICAgIHJldHVybiBjO1xuICB9XG5cbiAgZm9yRWFjaCh2aXNpdG9yOiAodmFsdWU6IFQsIGluZGV4PzogbnVtYmVyKSA9PiB2b2lkKSB7XG4gICAgbGV0IGM6IFQgfCBudWxsID0gdGhpcy5faGVhZDtcbiAgICBsZXQgaSA9IDA7XG4gICAgd2hpbGUgKGMpIHtcbiAgICAgIHZpc2l0b3IoYywgaSk7XG4gICAgICBpKys7XG4gICAgICBjID0gYy5uZXh0O1xuICAgIH1cbiAgfVxufVxuIl19