"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const exception_1 = require("../exception/exception");
class InvalidPathException extends exception_1.BaseException {
    constructor(path) { super(`Path "${path}" is invalid.`); }
}
exports.InvalidPathException = InvalidPathException;
function relativePath(from, to) {
    let p;
    if (from == to) {
        p = '';
    }
    else {
        const splitFrom = from.split('/');
        const splitTo = to.split('/');
        while (splitFrom.length > 0 && splitTo.length > 0 && splitFrom[0] == splitTo[0]) {
            splitFrom.shift();
            splitTo.shift();
        }
        if (splitFrom.length == 0) {
            p = splitTo.join('/');
        }
        else {
            p = splitFrom.map(_ => '..').concat(splitTo).join('/');
        }
    }
    return p;
}
exports.relativePath = relativePath;
function normalizePath(path) {
    let p = path;
    if (p[0] != '/') {
        p = '/' + p;
    }
    if (p.endsWith('..')) {
        throw new InvalidPathException(path);
    }
    let oldP = null;
    while (oldP !== p) {
        oldP = p;
        p = p
            .replace(/\/[^\/]+\/\.\.\//g, '/')
            .replace(/\/[^\/]+\/\.\.$/g, '/')
            .replace(/\/\.?$/g, '/')
            .replace(/\/\.?\//g, '/')
            .replace(/\\/g, '/');
    }
    if (p.startsWith('/../') || (p.endsWith('/') && p !== '/')) {
        throw new InvalidPathException(path);
    }
    return p;
}
exports.normalizePath = normalizePath;
//# sourceMappingURL=data:application/json;base64,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