"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = require("fs");
const path_1 = require("path");
const export_ref_1 = require("./export-ref");
const file_system_engine_host_base_1 = require("./file-system-engine-host-base");
/**
 * A simple EngineHost that uses a root with one directory per collection inside of it. The
 * collection declaration follows the same rules as the regular FileSystemEngineHostBase.
 */
class FileSystemEngineHost extends file_system_engine_host_base_1.FileSystemEngineHostBase {
    constructor(_root) {
        super();
        this._root = _root;
    }
    _resolveCollectionPath(name) {
        // Allow `${_root}/${name}.json` as a collection.
        if (fs_1.existsSync(path_1.join(this._root, name + '.json'))) {
            return path_1.join(this._root, name + '.json');
        }
        // Allow `${_root}/${name}/collection.json.
        if (fs_1.existsSync(path_1.join(this._root, name, 'collection.json'))) {
            return path_1.join(this._root, name, 'collection.json');
        }
        return null;
    }
    _resolveReferenceString(refString, parentPath) {
        // Use the same kind of export strings as NodeModule.
        const ref = new export_ref_1.ExportStringRef(refString, parentPath);
        if (!ref.ref) {
            return null;
        }
        return { ref: ref.ref, path: ref.module };
    }
    _transformCollectionDescription(_name, desc) {
        if (!desc.name || !desc.path || !desc.schematics || !desc.version) {
            return null;
        }
        if (typeof desc.schematics != 'object') {
            return null;
        }
        return desc;
    }
    _transformSchematicDescription(_name, _collection, desc) {
        if (!desc.factoryFn || !desc.path || !desc.description) {
            return null;
        }
        return desc;
    }
}
exports.FileSystemEngineHost = FileSystemEngineHost;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmlsZS1zeXN0ZW0tZW5naW5lLWhvc3QuanMiLCJzb3VyY2VSb290IjoiL1VzZXJzL2hhbnNsL1NvdXJjZXMvZGV2a2l0LyIsInNvdXJjZXMiOlsicGFja2FnZXMvYW5ndWxhcl9kZXZraXQvc2NoZW1hdGljcy90b29scy9maWxlLXN5c3RlbS1lbmdpbmUtaG9zdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQVlBLDJCQUFnQztBQUNoQywrQkFBNEI7QUFFNUIsNkNBQStDO0FBQy9DLGlGQUEwRTtBQVkxRTs7O0dBR0c7QUFDSCwwQkFBa0MsU0FBUSx1REFBd0I7SUFDaEUsWUFBc0IsS0FBYTtRQUFJLEtBQUssRUFBRSxDQUFDO1FBQXpCLFVBQUssR0FBTCxLQUFLLENBQVE7SUFBYSxDQUFDO0lBRXZDLHNCQUFzQixDQUFDLElBQVk7UUFDM0MsaURBQWlEO1FBQ2pELEVBQUUsQ0FBQyxDQUFDLGVBQVUsQ0FBQyxXQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxJQUFJLEdBQUcsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDakQsTUFBTSxDQUFDLFdBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLElBQUksR0FBRyxPQUFPLENBQUMsQ0FBQztRQUMxQyxDQUFDO1FBRUQsMkNBQTJDO1FBQzNDLEVBQUUsQ0FBQyxDQUFDLGVBQVUsQ0FBQyxXQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxJQUFJLEVBQUUsaUJBQWlCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUMxRCxNQUFNLENBQUMsV0FBSSxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsSUFBSSxFQUFFLGlCQUFpQixDQUFDLENBQUM7UUFDbkQsQ0FBQztRQUVELE1BQU0sQ0FBQyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRVMsdUJBQXVCLENBQUMsU0FBaUIsRUFBRSxVQUFrQjtRQUNyRSxxREFBcUQ7UUFDckQsTUFBTSxHQUFHLEdBQUcsSUFBSSw0QkFBZSxDQUFrQixTQUFTLEVBQUUsVUFBVSxDQUFDLENBQUM7UUFDeEUsRUFBRSxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztZQUNiLE1BQU0sQ0FBQyxJQUFJLENBQUM7UUFDZCxDQUFDO1FBRUQsTUFBTSxDQUFDLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxHQUFHLEVBQUUsSUFBSSxFQUFFLEdBQUcsQ0FBQyxNQUFNLEVBQUUsQ0FBQztJQUM1QyxDQUFDO0lBRVMsK0JBQStCLENBQUMsS0FBYSxFQUNiLElBQXVDO1FBQy9FLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7WUFDbEUsTUFBTSxDQUFDLElBQUksQ0FBQztRQUNkLENBQUM7UUFDRCxFQUFFLENBQUMsQ0FBQyxPQUFPLElBQUksQ0FBQyxVQUFVLElBQUksUUFBUSxDQUFDLENBQUMsQ0FBQztZQUN2QyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ2QsQ0FBQztRQUVELE1BQU0sQ0FBQyxJQUFnQyxDQUFDO0lBQzFDLENBQUM7SUFFUyw4QkFBOEIsQ0FBQyxLQUFhLEVBQ2IsV0FBcUMsRUFDckMsSUFBc0M7UUFDN0UsRUFBRSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsU0FBUyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO1lBQ3ZELE1BQU0sQ0FBQyxJQUFJLENBQUM7UUFDZCxDQUFDO1FBRUQsTUFBTSxDQUFDLElBQStCLENBQUM7SUFDekMsQ0FBQztDQUNGO0FBaERELG9EQWdEQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBHb29nbGUgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0IGh0dHBzOi8vYW5ndWxhci5pby9saWNlbnNlXG4gKi9cbmltcG9ydCB7XG4gIENvbGxlY3Rpb25EZXNjcmlwdGlvbixcbiAgUnVsZUZhY3RvcnksXG4gIFNjaGVtYXRpY0Rlc2NyaXB0aW9uLFxufSBmcm9tICdAYW5ndWxhci1kZXZraXQvc2NoZW1hdGljcyc7XG5pbXBvcnQgeyBleGlzdHNTeW5jIH0gZnJvbSAnZnMnO1xuaW1wb3J0IHsgam9pbiB9IGZyb20gJ3BhdGgnO1xuaW1wb3J0IHsgRmlsZVN5c3RlbUNvbGxlY3Rpb25EZXNjcmlwdGlvbiwgRmlsZVN5c3RlbVNjaGVtYXRpY0Rlc2NyaXB0aW9uIH0gZnJvbSAnLi9kZXNjcmlwdGlvbic7XG5pbXBvcnQgeyBFeHBvcnRTdHJpbmdSZWYgfSBmcm9tICcuL2V4cG9ydC1yZWYnO1xuaW1wb3J0IHsgRmlsZVN5c3RlbUVuZ2luZUhvc3RCYXNlIH0gZnJvbSAnLi9maWxlLXN5c3RlbS1lbmdpbmUtaG9zdC1iYXNlJztcblxuXG4vKipcbiAqIFVzZWQgdG8gc2ltcGxpZnkgdHlwaW5ncy5cbiAqL1xuZXhwb3J0IGRlY2xhcmUgdHlwZSBGaWxlU3lzdGVtQ29sbGVjdGlvbkRlc2NcbiAgPSBDb2xsZWN0aW9uRGVzY3JpcHRpb248RmlsZVN5c3RlbUNvbGxlY3Rpb25EZXNjcmlwdGlvbj47XG5leHBvcnQgZGVjbGFyZSB0eXBlIEZpbGVTeXN0ZW1TY2hlbWF0aWNEZXNjXG4gID0gU2NoZW1hdGljRGVzY3JpcHRpb248RmlsZVN5c3RlbUNvbGxlY3Rpb25EZXNjcmlwdGlvbiwgRmlsZVN5c3RlbVNjaGVtYXRpY0Rlc2NyaXB0aW9uPjtcblxuXG4vKipcbiAqIEEgc2ltcGxlIEVuZ2luZUhvc3QgdGhhdCB1c2VzIGEgcm9vdCB3aXRoIG9uZSBkaXJlY3RvcnkgcGVyIGNvbGxlY3Rpb24gaW5zaWRlIG9mIGl0LiBUaGVcbiAqIGNvbGxlY3Rpb24gZGVjbGFyYXRpb24gZm9sbG93cyB0aGUgc2FtZSBydWxlcyBhcyB0aGUgcmVndWxhciBGaWxlU3lzdGVtRW5naW5lSG9zdEJhc2UuXG4gKi9cbmV4cG9ydCBjbGFzcyBGaWxlU3lzdGVtRW5naW5lSG9zdCBleHRlbmRzIEZpbGVTeXN0ZW1FbmdpbmVIb3N0QmFzZSB7XG4gIGNvbnN0cnVjdG9yKHByb3RlY3RlZCBfcm9vdDogc3RyaW5nKSB7IHN1cGVyKCk7IH1cblxuICBwcm90ZWN0ZWQgX3Jlc29sdmVDb2xsZWN0aW9uUGF0aChuYW1lOiBzdHJpbmcpOiBzdHJpbmcgfCBudWxsIHtcbiAgICAvLyBBbGxvdyBgJHtfcm9vdH0vJHtuYW1lfS5qc29uYCBhcyBhIGNvbGxlY3Rpb24uXG4gICAgaWYgKGV4aXN0c1N5bmMoam9pbih0aGlzLl9yb290LCBuYW1lICsgJy5qc29uJykpKSB7XG4gICAgICByZXR1cm4gam9pbih0aGlzLl9yb290LCBuYW1lICsgJy5qc29uJyk7XG4gICAgfVxuXG4gICAgLy8gQWxsb3cgYCR7X3Jvb3R9LyR7bmFtZX0vY29sbGVjdGlvbi5qc29uLlxuICAgIGlmIChleGlzdHNTeW5jKGpvaW4odGhpcy5fcm9vdCwgbmFtZSwgJ2NvbGxlY3Rpb24uanNvbicpKSkge1xuICAgICAgcmV0dXJuIGpvaW4odGhpcy5fcm9vdCwgbmFtZSwgJ2NvbGxlY3Rpb24uanNvbicpO1xuICAgIH1cblxuICAgIHJldHVybiBudWxsO1xuICB9XG5cbiAgcHJvdGVjdGVkIF9yZXNvbHZlUmVmZXJlbmNlU3RyaW5nKHJlZlN0cmluZzogc3RyaW5nLCBwYXJlbnRQYXRoOiBzdHJpbmcpIHtcbiAgICAvLyBVc2UgdGhlIHNhbWUga2luZCBvZiBleHBvcnQgc3RyaW5ncyBhcyBOb2RlTW9kdWxlLlxuICAgIGNvbnN0IHJlZiA9IG5ldyBFeHBvcnRTdHJpbmdSZWY8UnVsZUZhY3Rvcnk8e30+PihyZWZTdHJpbmcsIHBhcmVudFBhdGgpO1xuICAgIGlmICghcmVmLnJlZikge1xuICAgICAgcmV0dXJuIG51bGw7XG4gICAgfVxuXG4gICAgcmV0dXJuIHsgcmVmOiByZWYucmVmLCBwYXRoOiByZWYubW9kdWxlIH07XG4gIH1cblxuICBwcm90ZWN0ZWQgX3RyYW5zZm9ybUNvbGxlY3Rpb25EZXNjcmlwdGlvbihfbmFtZTogc3RyaW5nLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBkZXNjOiBQYXJ0aWFsPEZpbGVTeXN0ZW1Db2xsZWN0aW9uRGVzYz4pIHtcbiAgICBpZiAoIWRlc2MubmFtZSB8fCAhZGVzYy5wYXRoIHx8ICFkZXNjLnNjaGVtYXRpY3MgfHwgIWRlc2MudmVyc2lvbikge1xuICAgICAgcmV0dXJuIG51bGw7XG4gICAgfVxuICAgIGlmICh0eXBlb2YgZGVzYy5zY2hlbWF0aWNzICE9ICdvYmplY3QnKSB7XG4gICAgICByZXR1cm4gbnVsbDtcbiAgICB9XG5cbiAgICByZXR1cm4gZGVzYyBhcyBGaWxlU3lzdGVtQ29sbGVjdGlvbkRlc2M7XG4gIH1cblxuICBwcm90ZWN0ZWQgX3RyYW5zZm9ybVNjaGVtYXRpY0Rlc2NyaXB0aW9uKF9uYW1lOiBzdHJpbmcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgX2NvbGxlY3Rpb246IEZpbGVTeXN0ZW1Db2xsZWN0aW9uRGVzYyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBkZXNjOiBQYXJ0aWFsPEZpbGVTeXN0ZW1TY2hlbWF0aWNEZXNjPikge1xuICAgIGlmICghZGVzYy5mYWN0b3J5Rm4gfHwgIWRlc2MucGF0aCB8fCAhZGVzYy5kZXNjcmlwdGlvbikge1xuICAgICAgcmV0dXJuIG51bGw7XG4gICAgfVxuXG4gICAgcmV0dXJuIGRlc2MgYXMgRmlsZVN5c3RlbVNjaGVtYXRpY0Rlc2M7XG4gIH1cbn1cbiJdfQ==