"use strict";
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const interface_1 = require("./tree/interface");
const static_1 = require("./tree/static");
var exception_1 = require("./exception/exception");
exports.SchematicsException = exception_1.SchematicsException;
__export(require("./tree/action"));
__export(require("./engine/collection"));
__export(require("./engine/engine"));
__export(require("./exception/exception"));
__export(require("./tree/interface"));
__export(require("./rules/base"));
__export(require("./rules/call"));
__export(require("./rules/move"));
__export(require("./rules/random"));
__export(require("./rules/schematic"));
__export(require("./rules/template"));
__export(require("./rules/url"));
__export(require("./tree/delegate"));
__export(require("./tree/empty"));
__export(require("./tree/filesystem"));
__export(require("./tree/virtual"));
__export(require("./engine/schematic"));
__export(require("./sink/dryrun"));
__export(require("./sink/filesystem"));
__export(require("./sink/host"));
__export(require("./sink/sink"));
const formats = require("./formats");
exports.formats = formats;
const workflow = require("./workflow");
exports.workflow = workflow;
exports.Tree = {
    empty() { return static_1.empty(); },
    branch(tree) { return static_1.branch(tree); },
    merge(tree, other, strategy = interface_1.MergeStrategy.Default) {
        return static_1.merge(tree, other, strategy);
    },
    partition(tree, predicate) {
        return static_1.partition(tree, predicate);
    },
    optimize(tree) { return static_1.optimize(tree); },
};
//# sourceMappingURL=data:application/json;base64,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