"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const core_1 = require("@angular-devkit/core");
// Used by schematics to throw exceptions.
class SchematicsException extends core_1.BaseException {
}
exports.SchematicsException = SchematicsException;
// Exceptions
class FileDoesNotExistException extends core_1.BaseException {
    constructor(path) { super(`Path "${path}" does not exist.`); }
}
exports.FileDoesNotExistException = FileDoesNotExistException;
class FileAlreadyExistException extends core_1.BaseException {
    constructor(path) { super(`Path "${path}" already exist.`); }
}
exports.FileAlreadyExistException = FileAlreadyExistException;
class ContentHasMutatedException extends core_1.BaseException {
    constructor(path) {
        super(`Content at path "${path}" has changed between the start and the end of an update.`);
    }
}
exports.ContentHasMutatedException = ContentHasMutatedException;
class InvalidUpdateRecordException extends core_1.BaseException {
    constructor() { super(`Invalid record instance.`); }
}
exports.InvalidUpdateRecordException = InvalidUpdateRecordException;
class MergeConflictException extends core_1.BaseException {
    constructor(path) {
        super(`A merge conflicted on path "${path}".`);
    }
}
exports.MergeConflictException = MergeConflictException;
class UnsuccessfulWorkflowExecution extends core_1.BaseException {
    constructor() {
        super('Workflow did not execute successfully.');
    }
}
exports.UnsuccessfulWorkflowExecution = UnsuccessfulWorkflowExecution;
class UnimplementedException extends core_1.BaseException {
    constructor() { super('This function is unimplemented.'); }
}
exports.UnimplementedException = UnimplementedException;
//# sourceMappingURL=data:application/json;base64,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