"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const rxjs_1 = require("rxjs");
const operators_1 = require("rxjs/operators");
const update_buffer_1 = require("../utility/update-buffer");
const sink_1 = require("./sink");
class HostSink extends sink_1.SimpleSinkBase {
    constructor(_host, _force = false) {
        super();
        this._host = _host;
        this._force = _force;
        this._filesToDelete = new Set();
        this._filesToRename = new Set();
        this._filesToCreate = new Map();
        this._filesToUpdate = new Map();
    }
    _validateCreateAction(action) {
        return this._force ? rxjs_1.EMPTY : super._validateCreateAction(action);
    }
    _validateFileExists(p) {
        if (this._filesToCreate.has(p) || this._filesToUpdate.has(p)) {
            return rxjs_1.of(true);
        }
        else if (this._filesToDelete.has(p)) {
            return rxjs_1.of(false);
        }
        else if ([...this._filesToRename.values()].some(([from]) => from == p)) {
            return rxjs_1.of(false);
        }
        else {
            return this._host.exists(p);
        }
    }
    _overwriteFile(path, content) {
        this._filesToUpdate.set(path, new update_buffer_1.UpdateBuffer(content));
        return rxjs_1.EMPTY;
    }
    _createFile(path, content) {
        this._filesToCreate.set(path, new update_buffer_1.UpdateBuffer(content));
        return rxjs_1.EMPTY;
    }
    _renameFile(from, to) {
        this._filesToRename.add([from, to]);
        return rxjs_1.EMPTY;
    }
    _deleteFile(path) {
        if (this._filesToCreate.has(path)) {
            this._filesToCreate.delete(path);
            this._filesToUpdate.delete(path);
        }
        else {
            this._filesToDelete.add(path);
        }
        return rxjs_1.EMPTY;
    }
    _done() {
        // Really commit everything to the actual filesystem.
        return rxjs_1.concat(rxjs_1.from([...this._filesToDelete.values()]).pipe(operators_1.concatMap(path => this._host.delete(path))), rxjs_1.from([...this._filesToRename.entries()]).pipe(operators_1.concatMap(([_, [path, to]]) => this._host.rename(path, to))), rxjs_1.from([...this._filesToCreate.entries()]).pipe(operators_1.concatMap(([path, buffer]) => {
            return this._host.write(path, buffer.generate());
        })), rxjs_1.from([...this._filesToUpdate.entries()]).pipe(operators_1.concatMap(([path, buffer]) => {
            return this._host.write(path, buffer.generate());
        }))).pipe(operators_1.reduce(() => { }));
    }
}
exports.HostSink = HostSink;
//# sourceMappingURL=data:application/json;base64,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