"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const options_1 = require("../node-package/options");
const options_2 = require("../repo-init/options");
const options_3 = require("../run-schematic/options");
const options_4 = require("../tslint-fix/options");
class BuiltinTaskExecutor {
}
BuiltinTaskExecutor.NodePackage = {
    name: options_1.NodePackageName,
    create: (options) => Promise.resolve().then(() => require('../node-package/executor')).then(mod => mod.default(options)),
};
BuiltinTaskExecutor.RepositoryInitializer = {
    name: options_2.RepositoryInitializerName,
    create: (options) => Promise.resolve().then(() => require('../repo-init/executor')).then(mod => mod.default(options)),
};
BuiltinTaskExecutor.RunSchematic = {
    name: options_3.RunSchematicName,
    create: () => Promise.resolve().then(() => require('../run-schematic/executor')).then(mod => mod.default()),
};
BuiltinTaskExecutor.TslintFix = {
    name: options_4.TslintFixName,
    create: () => Promise.resolve().then(() => require('../tslint-fix/executor')).then(mod => mod.default()),
};
exports.BuiltinTaskExecutor = BuiltinTaskExecutor;
//# sourceMappingURL=data:application/json;base64,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