"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const node_module_engine_host_1 = require("./node-module-engine-host");
/**
 * An EngineHost that uses a registry to super seed locations of collection.json files, but
 * revert back to using node modules resolution. This is done for testing.
 */
class NodeModulesTestEngineHost extends node_module_engine_host_1.NodeModulesEngineHost {
    constructor() {
        super(...arguments);
        this._collections = new Map();
        this._tasks = [];
    }
    get tasks() { return this._tasks; }
    clearTasks() { this._tasks = []; }
    registerCollection(name, path) {
        this._collections.set(name, path);
    }
    transformContext(context) {
        const oldAddTask = context.addTask;
        context.addTask = (task, dependencies) => {
            this._tasks.push(task.toConfiguration());
            return oldAddTask.call(context, task, dependencies);
        };
        return context;
    }
    _resolveCollectionPath(name) {
        const maybePath = this._collections.get(name);
        if (maybePath) {
            return maybePath;
        }
        return super._resolveCollectionPath(name);
    }
}
exports.NodeModulesTestEngineHost = NodeModulesTestEngineHost;
//# sourceMappingURL=data:application/json;base64,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