"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var MergeStrategy;
(function (MergeStrategy) {
    MergeStrategy[MergeStrategy["AllowOverwriteConflict"] = 2] = "AllowOverwriteConflict";
    MergeStrategy[MergeStrategy["AllowCreationConflict"] = 4] = "AllowCreationConflict";
    MergeStrategy[MergeStrategy["AllowDeleteConflict"] = 8] = "AllowDeleteConflict";
    // Uses the default strategy.
    MergeStrategy[MergeStrategy["Default"] = 0] = "Default";
    // Error out if 2 files have the same path. It is useful to have a different value than
    // Default in this case as the tooling Default might differ.
    MergeStrategy[MergeStrategy["Error"] = 1] = "Error";
    // Only content conflicts are overwritten.
    MergeStrategy[MergeStrategy["ContentOnly"] = 2] = "ContentOnly";
    // Overwrite everything with the latest change.
    MergeStrategy[MergeStrategy["Overwrite"] = 14] = "Overwrite";
})(MergeStrategy = exports.MergeStrategy || (exports.MergeStrategy = {}));
exports.FileVisitorCancelToken = Symbol();
exports.TreeSymbol = (function () {
    const globalSymbol = (typeof window == 'object' && window.window === window && window.Symbol)
        || (typeof self == 'object' && self.self === self && self.Symbol)
        || (typeof global == 'object' && global.global === global && global.Symbol);
    if (!globalSymbol) {
        return Symbol('schematic-tree');
    }
    if (!globalSymbol.schematicTree) {
        globalSymbol.schematicTree = Symbol('schematic-tree');
    }
    return globalSymbol.schematicTree;
})();
var Tree;
(function (Tree) {
    function isTree(maybeTree) {
        return exports.TreeSymbol in maybeTree;
    }
    Tree.isTree = isTree;
})(Tree || (Tree = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZXJmYWNlLmpzIiwic291cmNlUm9vdCI6Ii4vIiwic291cmNlcyI6WyJwYWNrYWdlcy9hbmd1bGFyX2RldmtpdC9zY2hlbWF0aWNzL3NyYy90cmVlL2ludGVyZmFjZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQVdBLElBQVksYUFtQlg7QUFuQkQsV0FBWSxhQUFhO0lBQ3ZCLHFGQUFrQyxDQUFBO0lBQ2xDLG1GQUFrQyxDQUFBO0lBQ2xDLCtFQUFrQyxDQUFBO0lBRWxDLDZCQUE2QjtJQUM3Qix1REFBNkIsQ0FBQTtJQUU3Qix1RkFBdUY7SUFDdkYsNERBQTREO0lBQzVELG1EQUFrQyxDQUFBO0lBRWxDLDBDQUEwQztJQUMxQywrREFBZ0UsQ0FBQTtJQUVoRSwrQ0FBK0M7SUFDL0MsNERBRTZELENBQUE7QUFDL0QsQ0FBQyxFQW5CVyxhQUFhLEdBQWIscUJBQWEsS0FBYixxQkFBYSxRQW1CeEI7QUFHWSxRQUFBLHNCQUFzQixHQUFXLE1BQU0sRUFBRSxDQUFDO0FBNkIxQyxRQUFBLFVBQVUsR0FBVyxDQUFDO0lBQ2pDLE1BQU0sWUFBWSxHQUFHLENBQUMsT0FBTyxNQUFNLElBQUksUUFBUSxJQUFJLE1BQU0sQ0FBQyxNQUFNLEtBQUssTUFBTSxJQUFJLE1BQU0sQ0FBQyxNQUFNLENBQUM7V0FDeEUsQ0FBQyxPQUFPLElBQUksSUFBSSxRQUFRLElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxJQUFJLElBQUksSUFBSSxDQUFDLE1BQU0sQ0FBQztXQUM5RCxDQUFDLE9BQU8sTUFBTSxJQUFJLFFBQVEsSUFBSSxNQUFNLENBQUMsTUFBTSxLQUFLLE1BQU0sSUFBSSxNQUFNLENBQUMsTUFBTSxDQUFDLENBQUM7SUFFOUYsRUFBRSxDQUFDLENBQUMsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO1FBQ2xCLE1BQU0sQ0FBQyxNQUFNLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUNsQyxDQUFDO0lBRUQsRUFBRSxDQUFDLENBQUMsQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQztRQUNoQyxZQUFZLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ3hELENBQUM7SUFFRCxNQUFNLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQztBQUNwQyxDQUFDLENBQUMsRUFBRSxDQUFDO0FBK0JMLElBQVUsSUFBSSxDQUliO0FBSkQsV0FBVSxJQUFJO0lBQ1osZ0JBQXVCLFNBQWlCO1FBQ3RDLE1BQU0sQ0FBQyxrQkFBVSxJQUFJLFNBQVMsQ0FBQztJQUNqQyxDQUFDO0lBRmUsV0FBTSxTQUVyQixDQUFBO0FBQ0gsQ0FBQyxFQUpTLElBQUksS0FBSixJQUFJLFFBSWIiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgR29vZ2xlIEluYy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuICovXG5pbXBvcnQgeyBQYXRoLCBQYXRoRnJhZ21lbnQgfSBmcm9tICdAYW5ndWxhci1kZXZraXQvY29yZSc7XG5pbXBvcnQgeyBBY3Rpb24gfSBmcm9tICcuL2FjdGlvbic7XG5cblxuZXhwb3J0IGVudW0gTWVyZ2VTdHJhdGVneSB7XG4gIEFsbG93T3ZlcndyaXRlQ29uZmxpY3QgICAgPSAxIDw8IDEsXG4gIEFsbG93Q3JlYXRpb25Db25mbGljdCAgICAgPSAxIDw8IDIsXG4gIEFsbG93RGVsZXRlQ29uZmxpY3QgICAgICAgPSAxIDw8IDMsXG5cbiAgLy8gVXNlcyB0aGUgZGVmYXVsdCBzdHJhdGVneS5cbiAgRGVmYXVsdCAgICAgICAgICAgICAgICAgICA9IDAsXG5cbiAgLy8gRXJyb3Igb3V0IGlmIDIgZmlsZXMgaGF2ZSB0aGUgc2FtZSBwYXRoLiBJdCBpcyB1c2VmdWwgdG8gaGF2ZSBhIGRpZmZlcmVudCB2YWx1ZSB0aGFuXG4gIC8vIERlZmF1bHQgaW4gdGhpcyBjYXNlIGFzIHRoZSB0b29saW5nIERlZmF1bHQgbWlnaHQgZGlmZmVyLlxuICBFcnJvciAgICAgICAgICAgICAgICAgICAgID0gMSA8PCAwLFxuXG4gIC8vIE9ubHkgY29udGVudCBjb25mbGljdHMgYXJlIG92ZXJ3cml0dGVuLlxuICBDb250ZW50T25seSAgICAgICAgICAgICAgID0gTWVyZ2VTdHJhdGVneS5BbGxvd092ZXJ3cml0ZUNvbmZsaWN0LFxuXG4gIC8vIE92ZXJ3cml0ZSBldmVyeXRoaW5nIHdpdGggdGhlIGxhdGVzdCBjaGFuZ2UuXG4gIE92ZXJ3cml0ZSAgICAgICAgICAgICAgICAgPSBNZXJnZVN0cmF0ZWd5LkFsbG93T3ZlcndyaXRlQ29uZmxpY3RcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICArIE1lcmdlU3RyYXRlZ3kuQWxsb3dDcmVhdGlvbkNvbmZsaWN0XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgKyBNZXJnZVN0cmF0ZWd5LkFsbG93RGVsZXRlQ29uZmxpY3QsXG59XG5cblxuZXhwb3J0IGNvbnN0IEZpbGVWaXNpdG9yQ2FuY2VsVG9rZW46IHN5bWJvbCA9IFN5bWJvbCgpO1xuZXhwb3J0IHR5cGUgRmlsZVZpc2l0b3IgPSBGaWxlUHJlZGljYXRlPHZvaWQ+O1xuXG5leHBvcnQgaW50ZXJmYWNlIEZpbGVFbnRyeSB7XG4gIHJlYWRvbmx5IHBhdGg6IFBhdGg7XG4gIHJlYWRvbmx5IGNvbnRlbnQ6IEJ1ZmZlcjtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBEaXJFbnRyeSB7XG4gIHJlYWRvbmx5IHBhcmVudDogRGlyRW50cnkgfCBudWxsO1xuICByZWFkb25seSBwYXRoOiBQYXRoO1xuXG4gIHJlYWRvbmx5IHN1YmRpcnM6IFBhdGhGcmFnbWVudFtdO1xuICByZWFkb25seSBzdWJmaWxlczogUGF0aEZyYWdtZW50W107XG5cbiAgZGlyKG5hbWU6IFBhdGhGcmFnbWVudCk6IERpckVudHJ5O1xuICBmaWxlKG5hbWU6IFBhdGhGcmFnbWVudCk6IEZpbGVFbnRyeSB8IG51bGw7XG5cbiAgdmlzaXQodmlzaXRvcjogRmlsZVZpc2l0b3IpOiB2b2lkO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIEZpbGVQcmVkaWNhdGU8VD4ge1xuICAocGF0aDogUGF0aCwgZW50cnk/OiBSZWFkb25seTxGaWxlRW50cnk+IHwgbnVsbCk6IFQ7XG59XG5cbmRlY2xhcmUgY29uc3Qgd2luZG93OiB7IFN5bWJvbDogeyBzY2hlbWF0aWNUcmVlOiBzeW1ib2wgfSwgd2luZG93OiB7fSB9O1xuZGVjbGFyZSBjb25zdCBzZWxmOiB7IFN5bWJvbDogeyBzY2hlbWF0aWNUcmVlOiBzeW1ib2wgfSwgc2VsZjoge30gfTtcbmRlY2xhcmUgY29uc3QgZ2xvYmFsOiB7IFN5bWJvbDogeyBzY2hlbWF0aWNUcmVlOiBzeW1ib2wgfSwgZ2xvYmFsOiB7fSB9O1xuXG5leHBvcnQgY29uc3QgVHJlZVN5bWJvbDogc3ltYm9sID0gKGZ1bmN0aW9uKCkge1xuICBjb25zdCBnbG9iYWxTeW1ib2wgPSAodHlwZW9mIHdpbmRvdyA9PSAnb2JqZWN0JyAmJiB3aW5kb3cud2luZG93ID09PSB3aW5kb3cgJiYgd2luZG93LlN5bWJvbClcbiAgICAgICAgICAgICAgICAgICAgfHwgKHR5cGVvZiBzZWxmID09ICdvYmplY3QnICYmIHNlbGYuc2VsZiA9PT0gc2VsZiAmJiBzZWxmLlN5bWJvbClcbiAgICAgICAgICAgICAgICAgICAgfHwgKHR5cGVvZiBnbG9iYWwgPT0gJ29iamVjdCcgJiYgZ2xvYmFsLmdsb2JhbCA9PT0gZ2xvYmFsICYmIGdsb2JhbC5TeW1ib2wpO1xuXG4gIGlmICghZ2xvYmFsU3ltYm9sKSB7XG4gICAgcmV0dXJuIFN5bWJvbCgnc2NoZW1hdGljLXRyZWUnKTtcbiAgfVxuXG4gIGlmICghZ2xvYmFsU3ltYm9sLnNjaGVtYXRpY1RyZWUpIHtcbiAgICBnbG9iYWxTeW1ib2wuc2NoZW1hdGljVHJlZSA9IFN5bWJvbCgnc2NoZW1hdGljLXRyZWUnKTtcbiAgfVxuXG4gIHJldHVybiBnbG9iYWxTeW1ib2wuc2NoZW1hdGljVHJlZTtcbn0pKCk7XG5cblxuZXhwb3J0IGludGVyZmFjZSBUcmVlIHtcbiAgYnJhbmNoKCk6IFRyZWU7XG4gIG1lcmdlKG90aGVyOiBUcmVlLCBzdHJhdGVneT86IE1lcmdlU3RyYXRlZ3kpOiB2b2lkO1xuXG4gIHJlYWRvbmx5IHJvb3Q6IERpckVudHJ5O1xuXG4gIC8vIFJlYWRvbmx5LlxuICByZWFkKHBhdGg6IHN0cmluZyk6IEJ1ZmZlciB8IG51bGw7XG4gIGV4aXN0cyhwYXRoOiBzdHJpbmcpOiBib29sZWFuO1xuICBnZXQocGF0aDogc3RyaW5nKTogRmlsZUVudHJ5IHwgbnVsbDtcbiAgZ2V0RGlyKHBhdGg6IHN0cmluZyk6IERpckVudHJ5O1xuICB2aXNpdCh2aXNpdG9yOiBGaWxlVmlzaXRvcik6IHZvaWQ7XG5cbiAgLy8gQ2hhbmdlIGNvbnRlbnQgb2YgaG9zdCBmaWxlcy5cbiAgb3ZlcndyaXRlKHBhdGg6IHN0cmluZywgY29udGVudDogQnVmZmVyIHwgc3RyaW5nKTogdm9pZDtcbiAgYmVnaW5VcGRhdGUocGF0aDogc3RyaW5nKTogVXBkYXRlUmVjb3JkZXI7XG4gIGNvbW1pdFVwZGF0ZShyZWNvcmQ6IFVwZGF0ZVJlY29yZGVyKTogdm9pZDtcblxuICAvLyBTdHJ1Y3R1cmFsIG1ldGhvZHMuXG4gIGNyZWF0ZShwYXRoOiBzdHJpbmcsIGNvbnRlbnQ6IEJ1ZmZlciB8IHN0cmluZyk6IHZvaWQ7XG4gIGRlbGV0ZShwYXRoOiBzdHJpbmcpOiB2b2lkO1xuICByZW5hbWUoZnJvbTogc3RyaW5nLCB0bzogc3RyaW5nKTogdm9pZDtcblxuICBhcHBseShhY3Rpb246IEFjdGlvbiwgc3RyYXRlZ3k/OiBNZXJnZVN0cmF0ZWd5KTogdm9pZDtcbiAgcmVhZG9ubHkgYWN0aW9uczogQWN0aW9uW107XG59XG5cblxubmFtZXNwYWNlIFRyZWUge1xuICBleHBvcnQgZnVuY3Rpb24gaXNUcmVlKG1heWJlVHJlZTogb2JqZWN0KTogbWF5YmVUcmVlIGlzIFRyZWUge1xuICAgIHJldHVybiBUcmVlU3ltYm9sIGluIG1heWJlVHJlZTtcbiAgfVxufVxuXG5cbmV4cG9ydCBpbnRlcmZhY2UgVXBkYXRlUmVjb3JkZXIge1xuICAvLyBUaGVzZSBqdXN0IHJlY29yZCBjaGFuZ2VzLlxuICBpbnNlcnRMZWZ0KGluZGV4OiBudW1iZXIsIGNvbnRlbnQ6IEJ1ZmZlciB8IHN0cmluZyk6IFVwZGF0ZVJlY29yZGVyO1xuICBpbnNlcnRSaWdodChpbmRleDogbnVtYmVyLCBjb250ZW50OiBCdWZmZXIgfCBzdHJpbmcpOiBVcGRhdGVSZWNvcmRlcjtcbiAgcmVtb3ZlKGluZGV4OiBudW1iZXIsIGxlbmd0aDogbnVtYmVyKTogVXBkYXRlUmVjb3JkZXI7XG59XG4iXX0=