"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const core_1 = require("@angular-devkit/core");
const operators_1 = require("rxjs/operators");
function formatValidator(data, dataSchema, formats) {
    const registry = new core_1.schema.CoreSchemaRegistry();
    for (const format of formats) {
        registry.addFormat(format);
    }
    return registry
        .compile(dataSchema)
        .pipe(operators_1.mergeMap(validator => validator(data)));
}
exports.formatValidator = formatValidator;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZm9ybWF0LXZhbGlkYXRvci5qcyIsInNvdXJjZVJvb3QiOiIuLyIsInNvdXJjZXMiOlsicGFja2FnZXMvYW5ndWxhcl9kZXZraXQvc2NoZW1hdGljcy9zcmMvZm9ybWF0cy9mb3JtYXQtdmFsaWRhdG9yLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUE7Ozs7OztHQU1HO0FBQ0gsK0NBQXFFO0FBRXJFLDhDQUEwQztBQUcxQyx5QkFDRSxJQUFlLEVBQ2YsVUFBc0IsRUFDdEIsT0FBOEI7SUFFOUIsTUFBTSxRQUFRLEdBQUcsSUFBSSxhQUFNLENBQUMsa0JBQWtCLEVBQUUsQ0FBQztJQUVqRCxLQUFLLE1BQU0sTUFBTSxJQUFJLE9BQU8sRUFBRTtRQUM1QixRQUFRLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxDQUFDO0tBQzVCO0lBRUQsT0FBTyxRQUFRO1NBQ1osT0FBTyxDQUFDLFVBQVUsQ0FBQztTQUNuQixJQUFJLENBQUMsb0JBQVEsQ0FBQyxTQUFTLENBQUMsRUFBRSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUM7QUFDbEQsQ0FBQztBQWRELDBDQWNDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBJbmMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9hbmd1bGFyLmlvL2xpY2Vuc2VcbiAqL1xuaW1wb3J0IHsgSnNvbk9iamVjdCwgSnNvblZhbHVlLCBzY2hlbWEgfSBmcm9tICdAYW5ndWxhci1kZXZraXQvY29yZSc7XG5pbXBvcnQgeyBPYnNlcnZhYmxlIH0gZnJvbSAncnhqcyc7XG5pbXBvcnQgeyBtZXJnZU1hcCB9IGZyb20gJ3J4anMvb3BlcmF0b3JzJztcblxuXG5leHBvcnQgZnVuY3Rpb24gZm9ybWF0VmFsaWRhdG9yKFxuICBkYXRhOiBKc29uVmFsdWUsXG4gIGRhdGFTY2hlbWE6IEpzb25PYmplY3QsXG4gIGZvcm1hdHM6IHNjaGVtYS5TY2hlbWFGb3JtYXRbXSxcbik6IE9ic2VydmFibGU8c2NoZW1hLlNjaGVtYVZhbGlkYXRvclJlc3VsdD4ge1xuICBjb25zdCByZWdpc3RyeSA9IG5ldyBzY2hlbWEuQ29yZVNjaGVtYVJlZ2lzdHJ5KCk7XG5cbiAgZm9yIChjb25zdCBmb3JtYXQgb2YgZm9ybWF0cykge1xuICAgIHJlZ2lzdHJ5LmFkZEZvcm1hdChmb3JtYXQpO1xuICB9XG5cbiAgcmV0dXJuIHJlZ2lzdHJ5XG4gICAgLmNvbXBpbGUoZGF0YVNjaGVtYSlcbiAgICAucGlwZShtZXJnZU1hcCh2YWxpZGF0b3IgPT4gdmFsaWRhdG9yKGRhdGEpKSk7XG59XG4iXX0=