"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const virtual_1 = require("./virtual");
// TODO: Remove this along with VirtualTree in 7.0
class FilteredTree extends virtual_1.VirtualTree {
    constructor(tree, filter = () => true) {
        super();
        const virtualTree = (tree instanceof virtual_1.VirtualTree
            ? tree : virtual_1.VirtualTree.optimize(tree));
        // We don't know for sure that it's a FilteredTree, but we don't care;
        // VirtualTree has `tree`, we just need access to it because it's protected.
        const root = virtualTree.tree;
        const staging = virtualTree.staging;
        [...root.entries()].forEach(([path, entry]) => {
            if (filter(path, entry)) {
                this._tree.set(path, entry);
            }
        });
        [...staging.entries()].forEach(([path, entry]) => {
            if (filter(path, entry)) {
                this._cacheMap.set(path, entry);
            }
        });
        virtualTree.actions.forEach(action => {
            if (this._cacheMap.has(action.path) || this._tree.has(action.path)) {
                this._actions.push(action);
            }
        });
    }
}
exports.FilteredTree = FilteredTree;
//# sourceMappingURL=data:application/json;base64,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