"use strict";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
class LinkedList {
    constructor(_head) {
        this._head = _head;
    }
    get(l) {
        let c = this._head;
        while (c && l > 0) {
            l--;
            c = c.next;
        }
        return c;
    }
    get head() { return this._head; }
    get length() {
        let c = this._head;
        let i = 0;
        while (c) {
            i++;
            c = c.next;
        }
        return i;
    }
    reduce(accumulator, seed) {
        let c = this._head;
        let acc = seed;
        let i = 0;
        while (c) {
            acc = accumulator(acc, c, i);
            i++;
            c = c.next;
        }
        return acc;
    }
    find(predicate) {
        let c = this._head;
        let i = 0;
        while (c) {
            if (predicate(c, i)) {
                break;
            }
            i++;
            c = c.next;
        }
        return c;
    }
    forEach(visitor) {
        let c = this._head;
        let i = 0;
        while (c) {
            visitor(c, i);
            i++;
            c = c.next;
        }
    }
}
exports.LinkedList = LinkedList;
//# sourceMappingURL=data:application/json;base64,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