"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const options_1 = require("./options");
class RepositoryInitializerTask {
    constructor(workingDirectory, commitOptions) {
        this.workingDirectory = workingDirectory;
        this.commitOptions = commitOptions;
    }
    toConfiguration() {
        return {
            name: options_1.RepositoryInitializerName,
            options: {
                commit: !!this.commitOptions,
                workingDirectory: this.workingDirectory,
                authorName: this.commitOptions && this.commitOptions.name,
                authorEmail: this.commitOptions && this.commitOptions.email,
                message: this.commitOptions && this.commitOptions.message,
            },
        };
    }
}
exports.RepositoryInitializerTask = RepositoryInitializerTask;
//# sourceMappingURL=data:application/json;base64,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