import { OnInit } from '@angular/core';
import { FormControl, Validator } from '@angular/forms';
/**
 * Function that takes a control and returns either null when it’s valid, or an error object if it’s not.
 * @param digits The format of the number
 * @param MIN_VALUE The minimum value for the number
 * @param MAX_VALUE The maximum value for the number
 * @return An error object: 'format', 'minValue' or 'maxValue'; null in case the value is valid
 */
export declare function validateLocaleNumber(digits: string, MIN_VALUE?: number, MAX_VALUE?: number): Function;
export declare class LocaleNumberValidatorDirective implements Validator, OnInit {
    /**
     * Format: {minIntegerDigits}.{minFractionDigits}-{maxFractionDigits}.
     */
    l10nValidateNumber: string;
    validateLocaleNumber: string;
    minValue: number;
    maxValue: number;
    private digits;
    private readonly MIN_VALUE;
    private readonly MAX_VALUE;
    private validator;
    ngOnInit(): void;
    validate(formControl: FormControl): Function;
}
