import { ElementRef, Renderer2, AfterViewInit, OnChanges, SimpleChanges, OnDestroy } from '@angular/core';
import { ISubscription } from 'rxjs/Subscription';
export declare abstract class BaseDirective implements AfterViewInit, OnChanges, OnDestroy {
    protected el: ElementRef;
    protected renderer: Renderer2;
    valueAttribute: string;
    innerHTMLProperty: string;
    protected key: string;
    protected attributes: any[];
    protected subscriptions: ISubscription[];
    private element;
    private renderNode;
    private nodeValue;
    private textObserver;
    private readonly TEXT_MUTATION_CONFIG;
    private readonly SELECTOR;
    constructor(el: ElementRef, renderer: Renderer2);
    ngAfterViewInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
    protected abstract setup(): void;
    protected abstract replace(): void;
    protected abstract replaceText(): void;
    protected abstract replaceAttributes(): void;
    protected getAttributesData(): any;
    protected getAttributesKeys(): string[];
    protected abstract getValues(keys: string | string[]): string | any;
    protected setText(value: string): void;
    protected setAttributes(data: any): void;
    private addTextListener();
    private removeTextListener();
    private getText();
    private getKey();
    private getAttributes();
    private cancelSubscriptions();
}
