/**
 * Breadth First Search (BFS) algorithm for traversing & searching tree data structure of DOM
 * explores the neighbor nodes first, before moving to the next level neighbors.
 * Time complexity: between O(1) and O(|V|^2).
 */
export declare class BFS {
    private static readonly SELECTOR;
    private static readonly MAX_DEPTH;
    /**
     * Target node is a non empty text node.
     */
    static getTargetNode(rootNode: any): any;
    private static walk(rootNode);
    private static isTargetNode(node);
    /**
     * A valid node is not marked for translation.
     */
    private static isValidNode(node);
}
