import { ModuleWithProviders } from '@angular/core';
import { InjectorRef } from '../models/injector-ref';
import { Token } from '../models/types';
/**
 * Provides dependencies, pipes & directives for translating messages, dates & numbers.
 */
export declare class LocalizationModule {
    private injector;
    /**
     * Use in AppModule: new instances of LocaleService & TranslationService.
     */
    static forRoot(token?: Token): ModuleWithProviders;
    /**
     * Use in feature modules with lazy loading: new instance of TranslationService.
     */
    static forChild(token?: Token): ModuleWithProviders;
    constructor(injector: InjectorRef);
}
