import { LocaleConfig } from '../models/localization/locale-config';
/**
 * Implement this class-interface to create a custom storage for default locale & currency.
 */
export declare abstract class LocaleStorage {
    /**
     * This method must contain the logic to read the storage.
     * @param name 'defaultLocale' or 'currency'
     * @return A promise with the value of the given name
     */
    abstract read(name: string): Promise<string | null>;
    /**
     * This method must contain the logic to write the storage.
     * @param name 'defaultLocale' or 'currency'
     * @param value The value for the given name
     */
    abstract write(name: string, value: string): Promise<void>;
}
export declare class BrowserStorage implements LocaleStorage {
    private configuration;
    private hasCookie;
    private hasStorage;
    constructor(configuration: LocaleConfig);
    read(name: string): Promise<string | null>;
    write(name: string, value: string): Promise<void>;
    private getLocalStorage(name);
    private getSessionStorage(name);
    private getCookie(name);
    private setLocalStorage(name, value);
    private setSessionStorage(name, value);
    private setCookie(name, value);
}
