import { DecimalCode } from '../models/validation/decimal-code';
/**
 * Provides the methods to convert strings according to default locale.
 */
export interface ILocaleValidation {
    /**
     * Converts a string to a number according to default locale.
     * If the string cannot be converted to a number, returns NaN.
     */
    parseNumber(s: string): number | null;
}
export declare class LocaleValidation implements ILocaleValidation {
    private decimalCode;
    constructor(decimalCode: DecimalCode);
    parseNumber(s: string): number | null;
}
