import { EventEmitter } from '@angular/core';
import { Subject } from 'rxjs/Subject';
import { ILocaleConfig, LocaleConfig } from '../models/localization/locale-config';
import { ILocaleConfigAPI } from '../models/localization/locale-config-api';
import { LocaleStorage } from './locale-storage';
/**
 * Manages language, default locale & currency.
 */
export interface ILocaleService {
    languageCodeChanged: EventEmitter<string>;
    defaultLocaleChanged: EventEmitter<string>;
    currencyCodeChanged: EventEmitter<string>;
    loadTranslation: Subject<any>;
    /**
     * Configure the service in the application root module or in a feature module with lazy loading.
     */
    addConfiguration(): ILocaleConfigAPI;
    getConfiguration(): ILocaleConfig;
    init(): Promise<void>;
    getAvailableLanguages(): string[];
    getLanguageDirection(languageCode?: string): string;
    getCurrentLanguage(): string;
    getCurrentCountry(): string;
    getCurrentLocale(): string;
    getCurrentScript(): string;
    getCurrentNumberingSystem(): string;
    getCurrentCalendar(): string;
    getDefaultLocale(): string;
    getCurrentCurrency(): string;
    setCurrentLanguage(languageCode: string): void;
    setDefaultLocale(languageCode: string, countryCode: string, scriptCode?: string, numberingSystem?: string, calendar?: string): void;
    setCurrentCurrency(currencyCode: string): void;
}
export declare class LocaleService implements ILocaleService {
    private configuration;
    private storage;
    languageCodeChanged: EventEmitter<string>;
    defaultLocaleChanged: EventEmitter<string>;
    currencyCodeChanged: EventEmitter<string>;
    loadTranslation: Subject<any>;
    private defaultLocale;
    private currencyCode;
    constructor(configuration: LocaleConfig, storage: LocaleStorage);
    addConfiguration(): ILocaleConfigAPI;
    getConfiguration(): ILocaleConfig;
    init(): Promise<void>;
    getAvailableLanguages(): string[];
    getLanguageDirection(languageCode?: string): string;
    getCurrentLanguage(): string;
    getCurrentCountry(): string;
    getCurrentScript(): string;
    getCurrentLocale(): string;
    getCurrentNumberingSystem(): string;
    getCurrentCalendar(): string;
    getDefaultLocale(): string;
    getCurrentCurrency(): string;
    setCurrentLanguage(languageCode: string): void;
    setDefaultLocale(languageCode: string, countryCode: string, scriptCode?: string, numberingSystem?: string, calendar?: string): void;
    setCurrentCurrency(currencyCode: string): void;
    private initStorage();
    private initLanguage();
    private initDefaultLocale();
    private initCurrency();
    private getBrowserLanguage();
    private matchLanguage(languageCode);
    private sendLanguageEvents();
    private sendDefaultLocaleEvents();
    private sendCurrencyEvents();
    private sendTranslationEvents();
}
