import { ChangeDetectorRef } from '@angular/core';
import { Translation } from './translation';
import { LocaleService } from './locale.service';
import { TranslationService } from './translation.service';
/**
 * Provides 'lang' to the translate pipe,
 * 'defaultLocale' & 'currency' to localeDecimal, localePercent & localeCurrency pipes.
 */
export declare class Localization extends Translation {
    protected locale: LocaleService;
    protected translation: TranslationService;
    protected changeDetectorRef: ChangeDetectorRef;
    defaultLocale: string;
    currency: string;
    constructor(locale?: LocaleService, translation?: TranslationService, changeDetectorRef?: ChangeDetectorRef);
}
