import { TranslationConfig } from '../models/translation/translation-config';
/**
 * Implement this class-interface to create a custom handler for translated values.
 */
export declare abstract class TranslationHandler {
    /**
     * This method must contain the logic to parse the translated value.
     * @param path The path of the key
     * @param key The key that has been requested
     * @param value The translated value
     * @param args The parameters passed along with the key
     * @param lang The current language
     * @return The parsed value
     */
    abstract parseValue(path: string, key: string, value: string | null, args: any, lang: string): string;
}
export declare class DefaultTranslationHandler implements TranslationHandler {
    private configuration;
    constructor(configuration: TranslationConfig);
    parseValue(path: string, key: string, value: string | null, args: any, lang: string): string;
    private handleMissingValue(path);
    private handleArgs(value, args);
}
