import { Http } from '@angular/http';
import { Observable } from 'rxjs/Observable';
import 'rxjs/add/operator/map';
/**
 * Implement this class-interface to create a custom provider for translation data.
 */
export declare abstract class TranslationProvider {
    /**
     * This method must contain the logic of data access.
     * @param language The current language
     * @param args The parameter of addCustomProvider method
     * @return An observable of an object of translation data: {key: value}
     */
    abstract getTranslation(language: string, args: any): Observable<any>;
}
export declare class HttpTranslationProvider implements TranslationProvider {
    private http;
    constructor(http: Http);
    getTranslation(language: string, args: any): Observable<any>;
}
