import { EventEmitter } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import 'rxjs/add/operator/toPromise';
import 'rxjs/add/observable/merge';
import { LocaleService } from './locale.service';
import { ITranslationConfig, TranslationConfig } from '../models/translation/translation-config';
import { ITranslationConfigAPI } from '../models/translation/translation-config-api';
import { TranslationProvider } from './translation-provider';
import { TranslationHandler } from './translation-handler';
/**
 * Manages the translation data.
 */
export interface ITranslationService {
    translationChanged: EventEmitter<string>;
    translationError: EventEmitter<any>;
    /**
     * Configure the service in the application root module or in a feature module with lazy loading.
     */
    addConfiguration(): ITranslationConfigAPI;
    getConfiguration(): ITranslationConfig;
    /**
     * Call this method after the configuration to initialize the service.
     */
    init(): Promise<void>;
    /**
     * Gets the current language of the service.
     */
    getLanguage(): string;
    /**
     * Translates a key or an array of keys.
     * @param keys The key or an array of keys to be translated
     * @param args Optional parameters contained in the key
     * @param lang The current language of the service is used by default
     * @return The translated value or an object: {key: value}
     */
    translate(keys: string | string[], args?: any, lang?: string): string | any;
    translateAsync(keys: string | string[], args?: any, lang?: string): Observable<string | any>;
}
export declare class TranslationService implements ITranslationService {
    private locale;
    private configuration;
    private translationProvider;
    private translationHandler;
    translationChanged: EventEmitter<string>;
    translationError: EventEmitter<any>;
    private serviceState;
    private loadingMode;
    private language;
    /**
     * The translation data: {language: {key: value}}.
     */
    private translationData;
    constructor(locale: LocaleService, configuration: TranslationConfig, translationProvider: TranslationProvider, translationHandler: TranslationHandler);
    addConfiguration(): ITranslationConfigAPI;
    getConfiguration(): ITranslationConfig;
    init(): Promise<void>;
    getLanguage(): string;
    translate(keys: string | string[], args?: any, lang?: string): string | any;
    translateAsync(keys: string | string[], args?: any, lang?: string): Observable<string | any>;
    private translateKey(key, args, lang);
    private getValue(key, args, lang);
    private translateI18nPlural(key, args, lang);
    private translateNumber(keyNumber);
    private loadTranslation();
    private getTranslation(language);
    private addData(data, language);
    private releaseTranslation(language);
    private sendEvents();
}
