# angular-leaflet-directive
## [tombatossals](http://github.com/tombatossals/angular-leaflet-directive) - main upstream
[![Join the chat at https://gitter.im/tombatossals/angular-leaflet-directive](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/tombatossals/angular-leaflet-directive?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)

[![Build Status](https://travis-ci.org/tombatossals/angular-leaflet-directive.png)](https://travis-ci.org/tombatossals/angular-leaflet-directive)

[![Dependencies](https://david-dm.org/tombatossals/angular-leaflet-directive.svg)](https://david-dm.org/tombatossals/angular-leaflet-directive)&nbsp;
[![Dependencies](https://david-dm.org/tombatossals/angular-leaflet-directive/dev-status.svg)](https://david-dm.org/tombatossals/angular-leaflet-directive)&nbsp;

[![Coverage
Status](https://coveralls.io/repos/tombatossals/angular-leaflet-directive/badge.png?branch=master)](http://tombatossals.github.io/angular-leaflet-directive/coverage/PhantomJS%201.9.7%20%28Linux%29/lcov-report/dist/angular-leaflet-directive.js.html)

## [realtymaps](http://github.com/realtymaps/angular-leaflet-directive)
[![Build Status](https://travis-ci.org/realtymaps/angular-leaflet-directive.png)](https://travis-ci.org/realtymaps/angular-leaflet-directive)

[![Dependencies](https://david-dm.org/realtymaps/angular-leaflet-directive.svg)](https://david-dm.org/realtymaps/angular-leaflet-directive)&nbsp;
[![Dependencies](https://david-dm.org/realtymaps/angular-leaflet-directive/dev-status.svg)](https://david-dm.org/realtymaps/angular-leaflet-directive)&nbsp;

[![Coverage
Status](https://coveralls.io/repos/realtymaps/angular-leaflet-directive/badge.png?branch=master)](http://realtymaps.github.io/angular-leaflet-directive/coverage/PhantomJS%201.9.7%20%28Linux%29/lcov-report/dist/angular-leaflet-directive.js.html)


[AngularJS](http://angularjs.org/) directive for the Leaflet Javascript
Library. This software aims to easily embed maps managed by leaflet on your
[Leaflet](http://leaflet.cloudmade.com) project.

You can browse all the examples added by the community to learn about the directive and its possibilities here:

http://tombatossals.github.io/angular-leaflet-directive/examples/0000-viewer.html

Or you can see some examples directly:

* [Basic example](http://tombatossals.github.io/angular-leaflet-directive/examples/0100-basic-first-example.html)
* [Center example](http://tombatossals.github.io/angular-leaflet-directive/examples/0101-basic-center-example.html)
* [Center autodiscover example](http://tombatossals.github.io/angular-leaflet-directive/examples/0102-basic-center-autodiscover-example.html )
* [Center with url hash example](http://tombatossals.github.io/angular-leaflet-directive/examples/0103-basic-center-url-hash-example.html)
* [Custom parameters example](http://tombatossals.github.io/angular-leaflet-directive/examples/0104-basic-custom-parameters-example.html)
* [Draw controls example](http://tombatossals.github.io/angular-leaflet-directive/examples/0401-controls-draw-example.html)
* [Bounds example](http://tombatossals.github.io/angular-leaflet-directive/examples/0105-basic-bounds-example.html)
* [MaxBounds example](http://tombatossals.github.io/angular-leaflet-directive/examples/0106-basic-maxbounds-example.html)
* [Tiles example](http://tombatossals.github.io/angular-leaflet-directive/examples/0107-basic-tiles-example.html)
* [Tile zoom changer example](http://tombatossals.github.io/angular-leaflet-directive/examples/0108-basic-tiles-zoom-changer-example.html)
* [Layers simple example](http://tombatossals.github.io/angular-leaflet-directive/examples/0201-layers-simple-example.html)
* [Overlays simple example](http://tombatossals.github.io/angular-leaflet-directive/examples/0202-layers-overlays-simple-example.html)
* [ImageOverlay simple example](http://tombatossals.github.io/angular-leaflet-directive/examples/0202-layers-overlays-simple-example.html)
* [Dynamic add/remove layers/overlays example](http://tombatossals.github.io/angular-leaflet-directive/examples/0204-layers-dynamic-addition-example.html)
* [Google Maps example](http://tombatossals.github.io/angular-leaflet-directive/examples/0205-layers-googlemaps-example.html)
* [Hide a layer in the layer selector example](http://tombatossals.github.io/angular-leaflet-directive/examples/0207-layers-hide-baselayer-on-selector-example.html)
* [ESRI Dynamic Layer example](http://tombatossals.github.io/angular-leaflet-directive/examples/0208-layers-esri-dynamic-layer-example.html)
* [ESRI Legend example](http://tombatossals.github.io/angular-leaflet-directive/examples/0209-layers-esri-legend-service-example.html)
* [Paths Simple example](http://tombatossals.github.io/angular-leaflet-directive/examples/0300-paths-simple-example.html)
* [Paths Types example](http://tombatossals.github.io/angular-leaflet-directive/examples/0301-paths-types-example.html)
* [Paths example](http://tombatossals.github.io/angular-leaflet-directive/examples/0304-paths-advanced-example.html)
* [Single marker example](http://tombatossals.github.io/angular-leaflet-directive/examples/0500-markers-simple-example.html)
* [Marker with label example](http://tombatossals.github.io/angular-leaflet-directive/examples/0505-markers-label-example.html)
* [Marker change opacity example](http://tombatossals.github.io/angular-leaflet-directive/examples/0507-markers-change-opacity-example.html)
* [Marker with Angular templates example](http://tombatossals.github.io/angular-leaflet-directive/examples/0514-markers-angular-template-example.html)
* [Marker with group clustering example](http://tombatossals.github.io/angular-leaflet-directive/examples/0508-markers-clustering-example.html)
* [Marker with group clustering example (10000 markers)](http://tombatossals.github.io/angular-leaflet-directive/examples/0511-markers-clustering-10000-markers-example.html)
* [Marker with group clustering example without overlays](http://tombatossals.github.io/angular-leaflet-directive/examples/0509-markers-clustering-without-overlays-example.html)
* [Marker groups example](http://tombatossals.github.io/angular-leaflet-directive/examples/0506-markers-groups-example.html)
* [Marker icons properties example](http://tombatossals.github.io/angular-leaflet-directive/examples/0503-markers-icons-example.html)
* [Markers dynamic add/remove example](http://tombatossals.github.io/angular-leaflet-directive/examples/0502-markers-add-remove-example.html)
* [Marker addition example](http://tombatossals.github.io/angular-leaflet-directive/examples/0501-markers-events-add-example.html)
* [Legend example](http://tombatossals.github.io/angular-leaflet-directive/examples/0600-mixed-image-legend-example.html)
* [GeoJson example](http://tombatossals.github.io/angular-leaflet-directive/examples/0113-basic-geojson-simple-example.html)
* [HeatMap example](http://tombatossals.github.io/angular-leaflet-directive/examples/0221-layers-heatmap-example.html)
* [Decoration example](http://tombatossals.github.io/angular-leaflet-directive/examples/0306-paths-decorations-simple-example.html)
* [UTFGrid example](http://tombatossals.github.io/angular-leaflet-directive/examples/0214-layers-utfgrid-example.html)
* [Events example](http://tombatossals.github.io/angular-leaflet-directive/examples/0115-basic-events-example.html)
* [Accessing the leaflet map object](http://tombatossals.github.io/angular-leaflet-directive/examples/0116-basic-access-leaflet-object-example.html)
* [Accessing the leaflet map object of two maps](http://tombatossals.github.io/angular-leaflet-directive/examples/0119-basic-double-map-access-map-object-example.html)
* [Two maps events](http://tombatossals.github.io/angular-leaflet-directive/examples/0118-basic-double-map-events-example.html)
* [Two maps with markers and events](http://tombatossals.github.io/angular-leaflet-directive/examples/0515-markers-two-maps-events-example.html)
* [Two maps sharing attributes](http://tombatossals.github.io/angular-leaflet-directive/examples/0120-basic-double-map-sharing-attributes-example.html)
* [Center map with GeoIP](http://tombatossals.github.io/angular-leaflet-directive/examples/0109-basic-center-geoip-example.html)

To see it in action, go to the main page where you can find more examples and
some documentation:

 * http://tombatossals.github.com/angular-leaflet-directive


## How to use it

You must include the leaflet-directive dependency on your angular module:
```
var app = angular.module("demoapp", ["leaflet-directive"]);
```

After that, you can change the default values of the directive (if you want) on
your angular controller. For example, you can change the tiles source, the
maxzoom on the leaflet map or the polyline path properties.

```javascript
angular.extend($scope, {
    defaults: {
        tileLayer: "http://{s}.tile.opencyclemap.org/cycle/{z}/{x}/{y}.png",
        maxZoom: 14,
        path: {
            weight: 10,
            color: '#800000',
            opacity: 1
        }
    }
});
```

If you want to set the start of the map to a precise position, you can define
the "center" property of the scope (lat, lng, zoom). It will be updated
interacting on the scope and on the leaflet map in two-way binding. Example:
```javascript
angular.extend($scope, {
    center: {
        lat: 51.505,
        lng: -0.09,
        zoom: 8
    }
});
```

If you need to run any method on the map object, use ```leafletData``` as following (notice the map object is returned in a form of a promise):

```javascript
angular.module('myModule').controller('MapController', ['$scope', 'leafletData',
	function($scope, leafletData) {
	        leafletData.getMap().then(function(map) {
	            L.GeoIP.centerMapOnPosition(map, 15);
	        });
	}
]);
```

Finally, you must include the markup directive on your HTML page, like this:
```html
<leaflet defaults="defaults" center="center" height="480px" width="640px"></leaflet>
```

If you want to have more than one map on the page and access their respective map objects, add an *id* attribute to your leaflet directive in HTML, like this:

```html
<leaflet id="mymap" defaults="defaults" center="center" height="480px" width="640px"></leaflet>
```

And then you can use this id in ```getMap()``` like this:

```javascript
angular.module('myModule').controller('MapController', ['$scope', 'leafletData',
	function($scope, leafletData) {
	        leafletData.getMap('mymap').then(function(map) {
	            L.GeoIP.centerMapOnPosition(map, 15);
	        });
	}
]);
```
